<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Tada</title>
  <meta content="" name="description">
  <meta content="" name="keywords">
  <link href="<?php echo e(url('public/download.png')); ?>" rel="icon" type="image/x-icon">
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <!-- Include Bootstrap CSS -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/css/bootstrap.min.css">

  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
  <style>
    body {
      font-family: 'Open Sans', sans-serif;
      background-color: #f8f9fa;
    }

    main {
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
    }

    .card {
      width: 100%;
      max-width: 500px;
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
      overflow: hidden;
    }

    .card-body {
      padding: 2rem;
    }

    .btMainLogo {
      display: block;
      margin: 0 auto;
    }

    .primary-btn {
      background-color: #94BC3D;
      color: #fff;
      transition: background-color 0.3s ease;
    }

    .primary-btn:hover {
      background-color: #FFCB08;
    }
  </style>
</head>

<body>
  <main>
    <div class="card">
      <div class="card-body">
        <?php if(Session::get('logo')): ?>
        <img class="mb-2 btMainLogo" alt="avatar1" src="<?php echo e(url('public/Image/'.Session::get('logo'))); ?>" height="100" width="120" data-hw="2.0642857142857">
        <?php else: ?>
        <i class="bi bi-person-circle" style="font-size: 50px;"></i>
        <?php endif; ?>

        <?php if($message = Session::get('success')): ?>
        <div class="alert alert-success" id="alert">
          <p><?php echo e($message); ?></p>
        </div>
        <?php endif; ?>

        <h5 class="text-center pb-0 fs-4"><strong>Login to Your Account</storng></h5>
        <p class="text-center small">Enter your username & password to login</p>

        <form action="<?php echo e(url('/signed')); ?>" method="post" class="row g-3 needs-validation" novalidate>
          <?php echo csrf_field(); ?>
          <div class="col-12">
            <label for="email" class="form-label">Your Email</label>
            <input type="email" name="email" class="form-control" id="email" required>
            <div class="invalid-feedback">Please enter a valid Email address!</div>
          </div>

          <div class="col-12">
            <label for="password" class="form-label">Password</label>
            <input type="password" name="password" class="form-control" id="password" required>
            <div class="invalid-feedback">Please enter your password!</div>
          </div>

          <div class="col-12">
            <button class="btn primary-btn w-100" type="submit">Login</button>
          </div>

          <div class="row mt-2">
            <div class="col-6">
              <a href="<?php echo e(route('forget.password.get')); ?>">
                <label class="form-check-label">Forget Password</label>
              </a>
            </div>
            <div class="col-6 text-end">
                <a href="<?php echo e(route('create.company')); ?>">
                    <label class="form-check-label">Create New Company</label>
                </a>
            </div>
          </div>
        </form>
      </div>
    </div>
  </main>


  <div class="modal fade" id="createCompanyModal" tabindex="-1" aria-labelledby="createCompanyModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createCompanyModalLabel">Create New Company</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Your form or content for creating a new company goes here -->
                
                <form method="post" action="<?php echo e(route('register.company')); ?>">
                    <?php echo csrf_field(); ?>

                      <div class="col-12">
                        <label for="company" class="form-label">Your Company Name</label>
                        <input type="company" name="company_name" class="form-control" required>
                      </div> 

                      <div class="col-12">
                        <label for="email" class="form-label">Your Email</label>
                        <input type="email" name="email" class="form-control" required>
                      </div>

                      <div class="col-12">
                        <label for="mobile" class="form-label">Your Phone</label>
                        <input type="text" name="mobile" class="form-control" required>
                      </div>

                      <div class="col-12">
                        <label for="password" class="form-label">Password</label>
                        <input type="password" name="password" class="form-control" required>
                      </div>

                      <div class="col-12">
                          <label for="state" class="form-label">State</label>
                          <select class="form-control" id="state-dropdown" name="state">
                              <option value="">Select State</option>
                              <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($state->id); ?>"><?php echo e($state->name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </select>
                      </div>

                      <!--<div class="col-12">
                          <label for="city" class="form-label">City</label>
                          <input type="city" name="city" class="form-control" required>
                      </div> -->


                      <div class="col-12">
                        <label for="address" class="form-label">Address</label>
                        <input type="address" name="address" class="form-control" required>
                      </div> 


                    <div class="col-12 text-center mt-4">
                        <button type="submit" class="btn primary-btn">Create Company</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>
</body>

</html>

<script type="text/javascript">
  
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
</script>



<?php /**PATH /home/vinecork/public_html/webdev/Company/resources/views/frontend/pages-login.blade.php ENDPATH**/ ?>