<?php $__env->startSection('main-container'); ?>

<main id="main" class="main">
    <?php echo $__env->make('cdn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="row page-titles mx-0">

        <div class="col-sm-6 p-md-0">

            <div class="breadcrumb-range-picker">

                 <h3>Vehicle</h3>

            </div>

        </div>

        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

            <a href="<?php echo e(route('vehicle.create')); ?>">

                <button type="button" class="btns success-btn btn-sm">

                    <i class="fas fa-plus"></i> Add Vehicle

                </button>

            </a>

        </div>

    </div>

    <div class="container-fluid">

        <?php echo $__env->make('flash_msg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <div class="table-responsive">

                            <table class="table table-hover" id="tabl">
                                
                                <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Vehicle Code</th>

                                    <th>Description</th>

                                    <th>Milage</th>

                                    <th>Fuel Capacity</th>

                                    <th>Fuel Type</th>

                                    <th>Status</th>

                                    <th>Action</th>

                                </tr>

                            </thead>

                            <tbody>

                                <?php if(!empty($vehicle)): ?>

                                    <?php $__currentLoopData = $vehicle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <tr>
                                            
                                            <td><?php echo e(++$key); ?></td>

                                            <td><?php echo e($value->Code); ?></td>

                                            <td><?php echo e($value->Description); ?></td>

                                            <td><?php echo e($value->Milage); ?></td>

                                            <td><?php echo e($value->FuelCapacity); ?></td>

                                            <td><?php echo e($value->FuelType); ?></td>

                                            <td>
                                                <?php if($value->Status=='1'): ?>
                                                    <label class="switch">
                                                        <input type="checkbox" checked>
                                                        <span class="slider round" onclick="inactiveStatus(<?php echo e($value->Id); ?>)" ></span>
                                                    </label>
                                                <?php else: ?>
                                                    <label class="switch">
                                                        <input type="checkbox">
                                                        <span class="slider round" onclick="activeStatus(<?php echo e($value->Id); ?>)"></span>
                                                    </label>
                                                <?php endif; ?>
                                                
                                            </td>

                                            <td>
                                                <a href="<?php echo e(route('vehicle.edit',encrypt($value->Id))); ?>" class="color-green" title="Edit" alt="Edit">
                                                    
                                                    <i class="fas fa-edit"></i> 
                                                    
                                                </a>
                                                |
                                                <a href="<?php echo e(route('vehicle.delete',encrypt($value->Id))); ?>" class="color-green" onclick="return confirm('Are you sure delete this?')" title="Delete" alt="Delete">
                                                    
                                                    <i class="fas fa-trash-alt"></i>
                                                    
                                                </a>
                                            </td>

                                        </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php endif; ?>
                                
                            </tbody>
                                
                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</main>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<script>
    function inactiveStatus(vehicle_id) {

        var conf = confirm('Are you sure want to inactive this record?');

        if(conf){
            $.ajax({
                url:"<?php echo e(route('vehicle.change.status')); ?>",
                type: "POST",
                data: {
                    vehicle_id: vehicle_id,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                dataType : 'json',
                success: function(result) {
                    
                }
            });
        }
        
   
    }
</script>

<script>
    function activeStatus(vehicle_id) {

        var conf = confirm('Are you sure want to active this record?');

        if(conf){
            $.ajax({
                url:"<?php echo e(route('vehicle.change.status')); ?>",
                type: "POST",
                data: {
                    vehicle_id: vehicle_id,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                dataType : 'json',
                success: function(result) {
                    console.log(result);
                }
            });
        }
        
   
    }
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.company.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vinecork/public_html/webdev/logisticcrm/resources/views/seller/vehicle/index.blade.php ENDPATH**/ ?>