<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\{RoleController,AdminController,CompanyServiceController,UserController,CompanyController,LocationController,ReportController,UsersController};
use App\Models\{Country,City,State,Company,Invoice,Currency,AllCurrency,Lead,Source,User,GroupUsers,Group,ServiceInvoice};
use App\Http\Middleware\Authenticate;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Auth\LoginController;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/forgetpassword',[CompanyServiceController::class,'ShowForgetPasswordForm'])->name('forget.password.get');

Route::post('forgetpassword',[CompanyServiceController::class,'SubmitForgetPasswordForm'])->name('forget.password.post');

Route::get('/resetpassword/{token}',[CompanyServiceController::class,'ShowResetPasswordForm'])->name('reset.password.get');

Route::post('resetpassword',[CompanyServiceController::class,'SubmitResetPasswordForm'])->name('reset.password.post');

Route::group(['middleware'=>['auth']],function(){
    Route::get('/index',[AdminController::class,'Dashboard']);

});

Route::get('/', function () {
    if(Auth::check())
    {
        if(Auth::check() && Auth::user()->role=='Admin'){
            return redirect('/index');
        } elseif (Auth::check() && Auth::user()->role=='Branch') {
            return redirect()->route('company.dashboard')->with('success','Company Login Successfully');
        } else {
            Auth::logout();
            Session::flush();
            return redirect()->back()->with('error','Try Again');;
        }
        
    }
    else
    {
        return view('frontend.pages-login');
    }
})->name('/');

Route::post('/signed',[AdminController::class,'signIn'])->name('signed');



Route::group(['middleware' => ['auth']], function() {
   /**
   * Logout Route
   */
   Route::post('/logout',[LoginController::class,'logout']);

});

Route::group(['middleware'=>['auth']],function(){

Route::resource('admin',AdminController::class);



Route::controller(UsersController::class)->group(function () {

        Route::get('users', 'index')->name('users');

        Route::get('user/create', 'create')->name('user.create');

        Route::post('user/store', 'store')->name('user.store');

        Route::get('user/edit/{id}', 'edit')->name('user.edit');

        Route::post('user/update/{id}', 'update')->name('user.update');

        Route::get('user/view/{id}', 'show')->name('user.view');

        Route::get('user/delete/{id}', 'destroy')->name('user.delete');

    });

    
Route::controller(LocationController::class)->group(function () {

        Route::get('locations', 'index')->name('locations');

        Route::get('location/create', 'create')->name('location.create');

        Route::post('location/store', 'store')->name('location.store');

        Route::get('location/edit/{id}', 'edit')->name('location.edit');

        Route::post('location/update/{id}', 'update')->name('location.update');

        Route::get('location/view/{id}', 'show')->name('location.view');

        Route::get('locationactive/{id}', 'location_active')->name('locationactive');

        Route::get('location/delete/{id}', 'destroy')->name('location.delete');

    });


Route::controller(ReportController::class)->group(function () {

        Route::get('reports', 'index')->name('reports');

        Route::get('report/create', 'create')->name('report.create');

        Route::post('report/store', 'store')->name('report.store');

        Route::get('report/edit/{id}', 'edit')->name('report.edit');

        Route::post('report/update/{id}', 'update')->name('report.update');

        Route::get('report/view/{id}', 'show')->name('report.view');

        Route::get('report/delete/{id}', 'destroy')->name('report.delete');

        Route::get('search', 'index')->name('report.search');

    });





Route::resource('role',RoleController::class);

Route::get('/addroles',[RoleController::class,'index'])->name('addroles');

Route::post('/role-submit',[RoleController::class,'submitRole']);

Route::get('/permissions/{id}',[RoleController::class,'show_permission']);

Route::post('/role-edit/{id}',[RoleController::class,'roleEdit']);

Route::get('/deleterole/{id}',[RoleController::class,'delete_Role']);

Route::get('onchangerole/{id}',[RoleController::class,'ChangeRole']);

Route::get('permis',function(){
    $role=Session::get('roles');
    $roles=Role::get();
    $permissions=Permission::get();
    $rolePermissions = $role->permissions->pluck('id')->toArray();

    $role_permission = Permission::get();

        $custom_permission = array();

        foreach($role_permission as $per){

            $key = substr($per->name, 0, strpos($per->name, "."));

            if(str_starts_with($per->name, $key)){
                $custom_permission[$key][] = $per;
            }

        }

    return view('frontend.permis',compact('role','roles','permissions','rolePermissions','custom_permission'));
});

// Users

Route::get('/users-profile',[AdminController::class,'UserProfile'])->name('users-profile');

Route::post('/update/profile',[AdminController::class,'update_profile'])->name('update.profile');

Route::POST('/login-with-user/{id}',[UserController::class,'UserLogin'])->name('login-with-user');



Route::view('components-view',"frontend.components-view");

Route::get('currency-page',[AdminController::class,'Currencyfun']);
Route::post('storecurrency',[AdminController::class,'SetCurrency']);
Route::post('/addnewcurrency',[AdminController::class,'AddCurrency']);
Route::get('/deletecurrency/{id}',[AdminController::class,'deleteCurrency']);

Auth::routes();




// Company
Route::get('/company', [CompanyController::class,'index'])->name('company.index');

Route::post('/company/update', [CompanyController::class,'update'])->name('update.company');

Route::post('/company/store', [CompanyController::class,'store'])->name('store.company');

Route::get('/company/delete/{id}', [CompanyController::class,'destroy'])->name('delete.company');

Route::resource('company',CompanyController::class);



// Customers  start

Route::get('/customeractive/{id}', [App\Http\Controllers\CustomerController::class,'customer_Active'])->name('customeractive');

Route::get('country-state-city', [App\Http\Controllers\CustomerController::class, 'getCountry']);

Route::post('get-states-by-country', [App\Http\Controllers\CustomerController::class, 'getState']);

Route::post('get-cities-by-state', [App\Http\Controllers\CustomerController::class, 'getCity']);


// Home Setting start

Route::get('/home_setting', [App\Http\Controllers\HomeSettingController::class,'index'])->name('home_setting');

Route::post('/sign-up/slider/update', [App\Http\Controllers\HomeSettingController::class,'signupsliderupdate'])->name('signup.slider.update');

Route::get('/remove/app/sign/{type}', [App\Http\Controllers\HomeSettingController::class,'remove_sign_slider'])->name('remove.app_sign');


});


