<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Login
Route::post('/login', [App\Http\Controllers\API\ApiController::class,'login']);

//users id show data
Route::post('/user', [App\Http\Controllers\API\ApiController::class,'userShowid']);


//users id show data
Route::post('/profile/update', [App\Http\Controllers\API\ApiController::class,'Profile_Updated']);

//users id show data
Route::get('/location', [App\Http\Controllers\API\ApiController::class,'Location_Show']);

//users id show data
Route::post('/report/store', [App\Http\Controllers\API\ApiController::class,'Report_Store']);


Route::post('/report/show/user', [App\Http\Controllers\API\ApiController::class,'Reports_Show']);


Route::post('/report/show/user/latest', [App\Http\Controllers\API\ApiController::class,'Reports_Show_Latest']);


Route::post('/report/details', [App\Http\Controllers\API\ApiController::class,'Reports_Details']);









