@extends('frontend.layouts.main')

@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h4>Users</h4>

        </div>

    </div>
    
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{route('user.create')}}">

            <button type="button" class="btns success-btn btn-sm">

                <i class="fas fa-plus"></i> Add User

            </button>

        </a>

    </div>
   

</div>

<div class="container-fluid" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" id="tabl">
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>NAME</th>

                                    <th>EMAIL</th>

                                    <th>MOBILE</th>

                                    <th>Role</th>
                                    
                                    <th>STATUS</th>

                                    <th>ACTION</th>

                                </tr>

                            </thead>

                            <tbody>
                                @if(!empty($users))
                                    @foreach($users as $key=>$value)
                                    <tr>
                                        <td>{{ ++$key }}</td>
                                        <td>{{ $value->name }}</td>
                                        <td>{{ $value->email }}</td>
                                        <td>{{ $value->mobile }}</td>
                                        <td>{{ $value->role }}</td>
                                        <td>
                                        @if($value->status=='1')
                                            <a href="{{url('customeractive/'.$value->id)}}">
                                                <button class="btns success-btn btn-sm">Active</button>
                                            </a>
                                        @else
                                            <a href="{{url('customeractive/'.$value->id)}}">
                                                <button class="btn btn-danger btn-sm">InActive</button>
                                            </a>
                                        @endif
                                        </td>
                                        <td >
                                            <a href="{{ route('user.view',encrypt($value->id)) }}" title="View More" alt="View More" class="color-green">
                                                <i class="fas fa-eye"></i> 
                                            </a> | 
                                            
                                            <a href="{{ route('user.edit',encrypt($value->id)) }}" title="Edit" alt="Edit" class="color-green">
                                               
                                                    <i class="fas fa-edit"></i> 
                                               
                                            </a> | 
                                           
                                            <a href="{{ route('user.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure delete this?')" title="Delete" alt="Delete" class="color-green">
                                               
                                                    <i class="fas fa-trash-alt"></i>
                                                
                                            </a>
                                           

                                        </td>

                                    </tr>
                                    @endforeach
                                @endif

                            </tbody>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->

<script type="text/javascript">
     $(document).ready(function () {
      $('#tabl').DataTable({
         
      });
  });
  </script>
  <!-- End #main -->

@endsection
