@extends('frontend.layouts.main')

@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h4>Add New Location</h4>

        </div>

    </div>

     <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{route('locations')}}">

            <button type="button" class="btns success-btn btn-sm">

                <i class="fas fa-arrow-left"></i> Back

            </button>

        </a>

    </div>

</div>



<div class="content-wrapper mt-4">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="{{route('location.store')}}" method="POST" class="form-sample" enctype="multipart/form-data">
                            {{ csrf_field() }}

                        <div class="row">

                            <div class="form-group col-lg-6">
                                <label>Location<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" value="{{old('name')}}" placeholder="Location" required>
                                <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
                            </div>

                            <div class="text-center">
                                <button type="submit" class="btns primary-btn btn-sm">Submit</button>
                            </div>

                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

    

</div>

</main><!-- End #main -->

 @endsection





