@extends('frontend.layouts.main')
@section('main-container')
@include('cdn')
<main id="main" class="main">
  <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
  <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
  @if($leads)
 <div style="margin-top:15px ;">
    <h4 class="text-uppercase mb-3">Search Result</h4>
 </div>
<table class="table table-striped display nowrap" id="tabl" style="width:100%;">
                <thead>
                    <tr>
                        <th></th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Country</th>
                        <th>Assign To</th>
                        <th>Created By</th>
                        <th>Remark View</th> 
                    </tr>
                </thead>
                <tbody> 
                 @foreach($leads as $key=>$value)
                  <tr>
                    <td></td>
                    <td>{{$value->name}}</td>
                    <td>{{$value->phone}}</td>                
                    <td>{{$value->country_info->name}}</td>
                    <td>
                        @if($value->assigned==0 or $value->assigned=='FreshPool' or $value->assigned=='leadPool' or $value->assigned=='ContactPool')
                          {{$value->assigned}}
                        @else
                            {{$value->assign->name}}
                        @endif
                    </td>
                    <td>{{$value->createdby->name}}</td>
                    <td>
                        <a class="btn btn-warning rounded-pill" role="button" data-toggle="modal" data-target="#remarkshow-{{ $value }}">Remark View</a>
                    </td>    

                        <!-- Modal for remark show -->
                        <div class="modal fade" id="remarkshow-{{ $value }}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="editModalLabel"> Remarks Lists</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>  
                              <div class="modal-body" style="background-color:#EFEDE7;">
                                <div class="row mb-2">
                                  <div class="col-md-6">
                                    <strong>Lead id:</strong>&ensp;{{$value->id}}
                                  </div>       
                                </div>
                                
                                @foreach($value->remark as $remark)
                                <div class="row mb-2" >
                                <div class="row mb-1 mt-1">
                                  <div class="col-md-5">
                                    <strong>Date:</strong>&ensp;{{$remark->created_at->format('d/m/Y')}}
                                  </div>
                                  <div class="col-md-7">
                                    <span><strong>Follow Up:&nbsp;</strong></span>
                                     @foreach($remark->followup_type as $arr)
                                     <span style="padding: 1px; background-color: #FBBE3F;">{{$arr}}&nbsp;</span>
                                     @endforeach
                                  </div>
                                 </div>
                                  <div class="row mb-1">       
                                     <span><strong>Remark:</strong>&ensp;<span style="text-transform:capitalize;">{{$remark->description}}</span></span> 
                                  </div>
                                </div>
                                 @endforeach
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <!-- <button type="submit" class="btn btn-primary">Ok</button> -->
                              </div>
                            
                            </div>
                            </div>
                            </div>
                   
                  </tr>
                @endforeach
                </tbody>
</table>
@else
  <h6 class="mt-5 text-center text-uppercase ">Result Not Found!</h6>
@endif      
</main>
<script type="text/javascript">  
   $(document).ready(function () {
    var table = $('#tabl').DataTable({
      order: [],
      columnDefs: [ { orderable: false, targets: [0,1,2,3,4,5,6] } ],
      bFilter: false, 
      responsive: true
    });

    new $.fn.dataTable.FixedHeader( table );
}); 
</script> 
@endsection