@extends('frontend.layouts.main')
@section('main-container')
@include('cdn')
<main id="main" class="main">
 <div style="margin-top:15px ;">
    <h4 class="text-uppercase mb-3">Paid Lead Details</h4>
 </div>
 <form  action="{{url('/multipleassign')}}" method="POST">
 @csrf            
  <div class="row mb-1">
  <div>
  @if(Auth::user()->role=="Admin")  
    <a role="button" data-toggle="modal" data-target="#assignLeadToManager{{$group_manager}}"><button class="btn btn-warning rounded-pill"><i class="bi bi-send-fill">Assign To Manager</i></button></a>
 
                        <!-- Modal -->
                        <div class="modal fade" id="assignLeadToManager{{$group_manager}}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel1" aria-hidden="true">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="editModalLabel1">Assign Lead To Group Manager</h5>
                                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"> 
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                              <div class="modal-body">
                                <div class="row mb-3">
                                  <label for="inputText" class="col-sm-3 col-form-label">Assign To:</label>
                                  <div class="col-sm-7">
                                   <select name="assigned_user_id1" class="form-control custom-select" style="text-transform:capitalize;">
                                     @if($group_manager)
                                    <option value="">Select Group Manager</option>
                                    @foreach($group_manager as $group)
                                    <option value="{{$group->group_manager}}">{{$group->UserName->name}}</option>
                                    @endforeach
                                    @endif
                                   </select>
                                  </div>          
                                </div>  
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <input type="submit" name="manager_form" value="Assign" class="btn btn-primary">
                                <!-- <button type="submit" class="btn btn-primary">Assign</button> -->
                              </div>
                            </div>
                          </div>
                        </div> 



    <a role="button" data-toggle="modal" data-target="#assignLeadToUser{{$users}}"><button class="btn btn-warning rounded-pill"><i class="bi bi-send-fill"></i>Assign To User</button></a>


                            <!-- Modal -->
                        <div class="modal fade" id="assignLeadToUser{{$users}}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel2" aria-hidden="true">
                         <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="editModalLabel2">Assign Lead To User</h5>
                                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                              <div class="modal-body">
                                <div class="row mb-3">
                                <label for="inputText" class="col-sm-3 col-form-label">Assign To:</label>
                                  <div class="col-sm-7">
                                   <select name="assigned_user_id2" class="form-control custom-select" style="text-transform:capitalize;">
                                      @if($users)
                                      <option value="">Select Users</option>
                                      @foreach($users as $user)
                                      @if($user->id==Auth::user()->id)
                                      @else
                                      <option value="{{$user->id}}">{{$user->name}}</option>
                                      @endif
                                      @endforeach
                                      @endif
                                   </select>
                                  </div>          
                                </div>  
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <input type="submit" name="user_form" class="btn btn-primary" value="Assign">
                                <!-- <button type="submit" class="btn btn-primary">Assign</button> -->
                              </div>
                          </div>
                         </div>
                        </div> 


  @endif
  @if(($g_manager!=null) )  
    <a role="button" data-toggle="modal" data-target="#assignLeadToGroupUser{{$group_user}}"><button class="btn btn-warning rounded-pill"><i class="bi bi-send-fill"></i>Assign To Group User</button></a>

                         <!-- Modal -->
                        <div class="modal fade" id="assignLeadToGroupUser{{$group_user}}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel3" aria-hidden="true">
                         <div class="modal-dialog" >
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="editModalLabel3">Assign Lead To Group User</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                              <div class="modal-body">
                                <div class="row mb-3">
                                <label for="inputText" class="col-sm-3 col-form-label">Assign To:</label>
                                  <div class="col-sm-7">
                                   <select name="assigned_user_id3" class="form-control custom-select" style="text-transform:capitalize;">
                                      @if($group_user)
                                      <option value="">Select Group Users</option>
                                      @foreach($group_user as $guser)
                                      <option value="{{$guser->user_id}}">{{$guser->UserName->name}}</option>
                                      @endforeach
                                      @endif
                                   </select>
                                  </div>          
                                </div>  
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Assign</button>
                              </div>
                          </div>
                         </div>
                        </div> 

  @endif
  </div>
 </div>
     <table class="table table-striped display nowrap" id="tabl" style="width:100%;">
                <thead>
                    <tr>
                        <th> </th>
                        <th> </th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Assigned To</th>
                        <th>Created By</th>
                        <th>View</th>
                        <th>Order</th>
                        <th>Remark</th> 
                    </tr>
                </thead>
                <tbody> 
                 @foreach($leads as $key=>$value)
                  <tr>
                    <td></td>
                    <td><input type="checkbox" name="assign_lead_id[]" class="form-check-inline" value="{{$value->id}}"></td></form>
                    <td>{{$value->name}}</td>
                    <td>{{$value->phone}}</td>   
                    <td>@if($value->assigned!=0){{$value->assign->name}}@endif</td> 
                    <td>{{$value->createdby->name}}</td>                    
                    <td>    
                       <a href="{{url('/leadmoreview/'.$value->id)}}" class="btn  rounded-pill" ><i class="bi bi-eye" style="color:blue;"></i></a>
                    </td>

                    <td> 
                      @can('Invoice.Create')
                      <a href="{{ route('salesorder.index',['id'=>$value->id])}}" role="button" class="btn btn-warning rounded-pill" >+</a> 
                      @endcan 
                    </td>   

                    <td>
                       @if($value->assigned==Auth::user()->id or $value->created_by==Auth::user()->id)
                      <a class="btn btn-success rounded-pill" role="button" data-toggle="modal" data-target="#remarklead{{ $key }}">+</a>
                      @else
                        <a class="btn btn-danger rounded-pill pt-1 pb-1">x</a>
                      @endif

                       <a class="btn btn-info rounded-pill" role="button" data-toggle="modal" data-target="#remarkshow{{ $key }}"><i class="bi bi-eye-fill"></i></a>
                    </td>

                            <!-- Modal for add remark -->
                            <div class="modal fade" id="remarklead{{ $key }}" tabindex="-1" role="dialog" aria-labelledby="remarkModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="remarkModalLabel" >Add Remark</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>  
                              <form action="{{url('saveremarklead/'.$value->id)}}" method="post">
                                {{ csrf_field() }}
                              <div class="modal-body" style="background-color:#F3F2EE ;">
                                <div class="row mb-3">
                                  <strong for="inputText" class=" col-form-label">Follow Up<span style="color:red;">*</span>:</strong>
                                  <div class="p-2">
                                   &ensp; &ensp;&ensp;<input class="form-check-input" type="checkbox" name="followup_type[]" id="inlineCheckbox1" value="Email" >&nbsp;Email &ensp; &ensp; &ensp;&ensp;&ensp;&ensp;
                                   <input class="form-check-input" type="checkbox" name="followup_type[]" value="Call" id="inlineCheckbox1">&nbsp; Call 
                                   &ensp; &ensp; &ensp;&ensp;&ensp;&ensp;
                                   <input class="form-check-input" type="checkbox" name="followup_type[]" value="Message" id="inlineCheckbox1">&nbsp; Message
                                  </div>          
                                </div>
                                <div class="row mb-3">
                                  <strong for="inputText" class=" col-form-label">Remark<span style="color:red;">*</span>:</strong>
                                  <div class="p-2">
                                   <textarea type="text" name="description" class="form-control" placeholder="Type Here.." required></textarea>
                                  </div>  
                                </div>  
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Submit</button>
                              </div>
                            </form>
                            </div>
                            </div>
                            </div>  
                 
                
                           <!-- Modal for remark show -->
                          <div class="modal fade" id="remarkshow{{ $key }}" tabindex="-1" role="dialog" aria-labelledby="remarkshowModalLabel" aria-hidden="true">
                          <div class="modal-dialog" role="document">
                          <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="remarkshowModalLabel"> Remarks Lists</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>  
                              <div class="modal-body" style="background-color:#EFEDE7;">
                                @if(count($value->remark)==0)
                                <div class="row mb-2">
                                  <div class="col-md-6">
                                    <strong>Remark Not Found!</strong>&ensp;
                                  </div>       
                                </div>
                                @else
                                @foreach($value->remark as $remark)
                                <div class="row mb-2" >
                                <div class="row mb-1 mt-1">
                                  <div class="col-md-5">
                                    <strong>Date:</strong>&ensp;{{$remark->created_at->format('d/m/Y')}}
                                  </div>
                                  <div class="col-md-7">
                                    <span><strong>Follow Up:&nbsp;</strong></span>
                                     @foreach($remark->followup_type as $arr)
                                     <span style="padding: 1px; background-color: #FBBE3F;">{{$arr}}&nbsp;</span>
                                     @endforeach
                                  </div>
                                 </div>
                                  <div class="row mb-1">       
                                     <span><strong>Remark:</strong>&ensp;<span style="text-transform:capitalize;">{{$remark->description}}</span></span> 
                                  </div>
                                </div>
                                 @endforeach
                                 @endif
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                              </div>  
                          </div>
                          </div>
                          </div>
                    
                  </tr>
                @endforeach
                </tbody>
      </table>      

</main>
<script type="text/javascript">  
   $(document).ready(function () {
    var table = $('#tabl').DataTable({
      order: [],
      columnDefs: [ { orderable: false, targets: [0,1,2,3,4,5,6,7,8] } ],
      bFilter: false, 
      responsive: true
    });

    new $.fn.dataTable.FixedHeader( table );
}); 
</script> 
 <script type="text/javascript">
   $('#close-modal').click(function () {
       document.location.reload();
   });
  </script>
  <script type="text/javascript">
   $('#refresh-modal').click(function () {
       document.location.reload();
   });
  </script>
@endsection
