@extends('frontend.layouts.main')
@section('main-container')
@include('cdn')
<main id="main" class="main">
<h4>Groups</h4>
 @can('Group.Create')
<div class="text-end mb-2">
<button type="button" class="btn btn-primary rounded-pill" data-toggle="modal" data-target="#newgroup-{{$users}}"><i class="bi bi-plus-circle-fill"></i>&nbsp; New Group</button>
</div>
@endcan
 <table class="table table-striped display nowrap" id="tabl" style="width:100%;">
            <thead>
                <tr>
                    <th>S.No</th>
                    <th>Group</th>
                    <th>Group Manager</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
              @foreach($groups as $key=>$value)
                    <tr>
                        <td>{{ ++$key }}</td>

                        <td style="text-transform:capitalize;">{{ $value->name }}</td>

                        <td style="text-transform:capitalize;">{{$value->UserName->name}}</td>
                        <td>
                           @can('Group.Edit')
                           <a class="btn " role="button" data-toggle="modal" data-target="#editGroup-{{ $value }}"><i class="bi bi-pencil-fill" style="color:navy;"></i></a>
                           @endcan

                           @can('Group.Status')
                             @if($value->status=='1')
                             <a href="{{url('groupstatus/'.$value->id)}}">
                                <button class="btn btn-success">Active</button>
                             </a>
                             @else
                             <a href="{{url('groupstatus/'.$value->id)}}">
                               <button class="btn btn-danger">InActive</button>
                             </a>
                             @endif
                           @endcan

                         <a href="{{url('/group-users/'.$value->id)}}" class="btn btn-primary" style="color:white;"><i class="bi bi-person-fill-add"></i> Member</a>
                        </td>

                        <!-- Modal for edit group-->
                            <div class="modal fade" id="editGroup-{{$value}}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header" style="background-color: #ffb74d;">
                                <h5 class="modal-title" id="editModalLabel">Edit Group</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>

                               <form action="{{url('group-edit/'.$value->id)}}" method="post">
                                {{ csrf_field() }}

                              <div class="modal-body">
                                <div class="row mb-3">
                                  <label for="inputText" class="col-sm-4 col-form-label">Group Name<span style="color:red;">*</span></label>
                                  <div class="col-sm-7">
                                    <input type="text" name="name" value="{{$value->name}}" class="form-control" style="text-transform: capitalize;" required>
                                  </div>
                                  </div>
                                  <div class="row mb-3">
                                  <label for="inputText" class="col-sm-4 col-form-label">Group Manager<span style="color:red;">*</span></label>
                                  <div class="col-sm-7">
                                  <select class="custom-select form-control" name="group_manager" style="text-transform:capitalize;" required>
                                    @foreach($users as $user)
                                    @if($user->id==$value->group_manager)
                                    <option value="{{$value->group_manager}}" selected>{{$value->userName->name}}</option>
                                    @else
                                    <option value="{{$user->id}}">{{$user->name}}</option>
                                    @endif
                                    @endforeach
                                  </select>
                                  </div>
                                </div>
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn " style="background-color: #ffb74d;">Edit</button>
                              </div>
                            </form>
                            </div>
                            </div>
                            </div>

                    </tr>
                   @endforeach
            </tbody>
  </table>

<!-- Modal -->
<div class="modal fade" id="newgroup-{{$users}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #ffb74d;">
        <h5 class="modal-title" id="exampleModalLabel">Add Group</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
       <form action="{{url('/savegroup')}}" method="post">
        {{ csrf_field() }}
      <div class="modal-body">
        <div class="row mb-3">
                  <label for="inputText" class="col-sm-4 col-form-label">Group Name<span style="color:red;">*</span></label>
                  <div class="col-sm-7">
                    <input type="text" name="name" class="form-control" placeholder="Enter Group Name" required>
                  </div>
          </div>
          <div class="row mb-3">
                  <label for="inputText" class="col-sm-4 col-form-label">Group Manager<span style="color:red;">*</span></label>
                  <div class="col-sm-7">
                  <select name="group_manager" class="custom-select form-control" required>
                    <option>Select Manager</option>
                    @foreach($users as $user)
                    <option value="{{$user->id}}">{{$user->name}}</option>
                    @endforeach
                  </select>
                  </div>
          </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="submit" class="btn" style="background-color: #ffb74d;">Add</button>
      </div>
    </form>
    </div>
  </div>
</div>
</main>
<script type="text/javascript">
   $(document).ready(function () {
    var table = $('#tabl').DataTable({
      order: [],
      columnDefs: [ { orderable: false, targets: [0,1,2,3] } ],
      responsive: true
    });

    new $.fn.dataTable.FixedHeader( table );
});
</script>
<script>
  $(function() {
    $('.toggle-class').change(function() {
        var status = $(this).prop('checked') == true ? 1 : 0;
        var group_id = $(this).data('id');
        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/groupstatus',
            data: {'status': status, 'group_id': group_id},
            success: function(data){
              console.log(data.success)
            }
        });
    })
  })
</script>
@endsection
