@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')
  <div style="margin-top:13px ;">
    <h4 class="text-uppercase mb-3">Lead Pool Details</h4>
  </div>

  <form action="{{url('/multipleassign')}}" method="POST">
    @csrf   

  <div class="mb-1">
   @if(Auth::user()->role=="Manager")
  
   <a role="button" data-toggle="modal" data-target="#assignLeadToGroupUser{{$group_user}}"><button class="btn btn-warning rounded-pill"><i class="bi bi-send-fill"></i>Assign To Group User</button></a>

                         <!-- Modal -->
                        <div class="modal fade" id="assignLeadToGroupUser{{$group_user}}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel3" aria-hidden="true">
                         <div class="modal-dialog" >
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="editModalLabel3">Assign Lead To Group User</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                              <div class="modal-body">
                                <div class="row mb-3">
                                <label for="inputText" class="col-sm-3 col-form-label">Assign To:</label>
                                  <div class="col-sm-7">
                                   <select name="assigned_user_id3" class="form-control custom-select" style="text-transform:capitalize;">
                                      @if($group_user)
                                      <option value="">Select Group Users</option>
                                      @foreach($group_user as $guser)
                                      <option value="{{$guser->user_id}}">{{$guser->UserName->name}}</option>
                                      @endforeach
                                      @endif
                                   </select>
                                  </div>          
                                </div>  
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Assign</button>
                              </div>
                          </div>
                         </div>
                        </div> 

  @endif
  </div>

  <table class="table table-striped display nowrap" id="tabl" style="width:100%;">
                <thead>
                    <tr>
                        <th> </th>
                        <th>#</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Created By</th>
                        <th>Action</th>
                      
                    </tr>
                </thead>
                <tbody> 
                 @foreach($leads as $key=>$value)
                  <tr>
                    <td> </td>
                    <td><input type="checkbox" name="assign_lead_id[]" class="form-check-inline" value="{{$value->id}}"></td>
                    <td>{{$value->name}}</td>
                    <td>{{$value->phone}}</td>  
                    <td>{{$value->createdby->name}}</td>           
                    <td>   

                      <a href="{{url('/leadmoreview/'.$value->id)}}" ><i class="bi bi-eye" style="color:blueviolet;"></i></a>

                     </td> 
                
                  </tr>
                @endforeach
                </tbody>
        </table>
  </form>
</main>
<script type="text/javascript">  
   $(document).ready(function () {
     var table = $('#tabl').DataTable({
      order: [],
      columnDefs: [ { orderable: false, targets: [0,1,2,3,4,5] } ],
      bFilter: false, 
      responsive: true
    });

    new $.fn.dataTable.FixedHeader( table );
  });
  </script>
@endsection
