@extends('frontend.layouts.main')
@section('main-container')
@include('cdn')
<main id="main" class="main">
<link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
<script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
<div>
  <h4>Lead Source</h4>
</div>
@can('Source.Create')
<div class="text-end mb-2">
<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addsource"><i class="bi bi-plus-circle-fill"></i> Add Source</button>
</div>
@endcan
 <table class="table table-striped display nowrap" id="tabl" style="width:100%;">
            <thead >
                <tr>
                    <th></th>
                    <th>S.No</th>
                    <th>Name</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody> 
              @foreach($source as $key=>$value)
                    <tr>
                        <td></td>
                        <td>{{ ++$key }}</td>
                        <td style="text-transform: capitalize;">{{ $value->name }}</td>
                        <td> 
                           <input data-id="{{$value->id}}" class="toggle-class" type="checkbox" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Active" data-off="InActive" {{ $value->status ? 'checked' : '' }}>
                        </td>
                        <td>
                          @can('Source.Edit')
                          <a class="btn " role="button" data-toggle="modal" data-target="#editsource-{{ $value->id }}" style="color:blue;"><i class="bi bi-pencil-fill"></i></a>
                          @endcan

                          @can('Source.Delete')
                            <a href="{{url('deletesource/'.$value->id)}}" ><button type="button" class="btn"><i class="bi bi-trash" style="color:red;"></i></button></a>
                          @endcan
                        </td>

                         <!-- Modal for edit source-->
                            <div class="modal fade" id="editsource-{{$value->id}}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header" style="background-color:#ffbb33;">
                                <h5 class="modal-title" id="editModalLabel">Edit Source</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                             
                            <form action="{{url('source-edit/'.$value->id)}}" method="post">
                                {{ csrf_field() }}
                              <div class="modal-body">
                                <div class="row mb-3">
                                  <label for="inputText" class="col-sm-2 col-form-label">Source</label>
                                  <div class="col-sm-7">
                                    <input type="text" name="name" value="{{$value->name}}" class="form-control" style="text-transform:capitalize;" required>
                                  </div>          
                                </div>  
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-warning">Edit</button>
                              </div>
                            </form>
                            </div>
                            </div>
                            </div>      
                    </tr>
                   @endforeach
            </tbody>
        </table>
<!-- Modal -->
<div class="modal fade" id="addsource" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header" style="background-color:#ffbb33;">
        <h5 class="modal-title" id="exampleModalLabel">Add Source</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
       <form action="{{url('/addsource')}}" method="post">
        {{ csrf_field() }}
      <div class="modal-body">
        <div class="row mb-3">
                  <label for="inputText" class="col-sm-2 col-form-label">Source</label>
                  <div class="col-sm-7">
                    <input type="text" name="name" class="form-control" placeholder="Enter Source" required>
                  </div>
                </div>  
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Add</button>
      </div>
    </form>
    </div>
  </div>
</div>
</main>
<script type="text/javascript">  
   $(document).ready(function () {
    var table = $('#tabl').DataTable({
      order: [],
      columnDefs: [ { orderable: false, targets: [0,1,2,3,4] } ], 
      responsive: true
    });

    new $.fn.dataTable.FixedHeader( table );
}); 
</script>
<script>
  $(function() {
    $('.toggle-class').change(function() {
        var status = $(this).prop('checked') == true ? 1 : 0; 
        var source_id = $(this).data('id'); 
         
        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/sourceStatus',
            data: {'status': status, 'source_id': source_id},
            success: function(data){
              console.log(data.success)
            }
        });
    })
  })
</script>
@endsection