 @extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')   
<div class="content-wrapper">
        <div class="row ">
          <div class="card">
            <div class="card-body">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group row ">
                   
                    <h4 class="card-title">LEAD INFORMATION</h4>
                  </div>
                </div>
              </div>
              <form action="{{url('/saveeditlead',$leads->id)}}" method="POST" class="form-sample">
               {{ csrf_field() }}
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Name<span style="color:red;">*</span></label>
                      <div class="col-sm-8">
                          <input type="text" name="name" class="form-control" value="{{$leads->name}}" placeholder="Enter Name" required />

                          @error('name')
                          <div class="alert alert-danger mt-1 mb-1">{{ $message }}</div>
                          @enderror
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Lead Source</label>
                      <div class="col-sm-7">
                        <select class="custom-select" name="l_source">
                          <option value="">Select Source</option>
                         @foreach($source as $sour)

                          @if($sour->id==$leads->l_source) 
                          <option value="{{$leads->l_source}}" selected>{{$leads->source->name}}</option>
                          @else
                           <option value="{{$sour->id}}">{{$sour->name}}</option>
                          @endif 
                         @endforeach
                        </select>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row">
                   <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Investment</label>
                      <div class="col-sm-8">
                        <input class="form-control" type="text" name="invest" value="{{$leads->invest}}">
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Trading Experience</label>
                      <div class="col-sm-7">
                        <input class="form-control" type="text" name="expense" value="{{$leads->expense}}">
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Trading Segment</label>
                      <div class="col-sm-8">
                        <input class="form-control" type="text" name="trade" value="{{$leads->trade}}">
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Created By</label>
                      <div class="col-sm-7">
                        <input class="form-control" type="text" name="created_by" value="{{$leads->createdby->name}}" readonly>
                      </div>
                    </div>
                  </div>
                </div>

                <h4 class="card-title">CONTACT INFO</h4>
               

                <div class="row">
                   <div class="col-md-6">
                        <div class="form-group row">
                          <label class="col-sm-4 col-form-label">Country<span style="color:red;">*</span></label>
                          <div class="col-sm-8">
                            <select class="custom-select" name="country" required>
                              @if($leads->country=='Default')
                              <option value="{{$leads->country}}">{{$leads->country}}</option>
                              @else
                              <option value="{{$leads->country}}">{{$leads->country_info->name}}</option>
                              @endif
                              @foreach($countries as $country)
                              
                              <option value="{{$country->id}}">{{$country->name}}</option>
                            
                              @endforeach 
                            </select>
                              @error('Country')
                              <div class="alert alert-danger mt-1 mb-1">{{ $message }}</div>
                              @enderror
                          </div>
                        </div>
                    </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Contact Number<span style="color:red;">*</span></label>
                      <div class="col-sm-7">
                        <input type="text" maxlength="15" name="phone" value="{{$leads->phone}}" class="form-control" placeholder="Enter Your Phone Number" required>
                      
                          @error('phone')
                        <div class="alert alert-danger mt-1 mb-1">{{ $message }}</div>
                        @enderror
                      </div>
                    </div>
                  </div>            
                </div>

                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Email</label>
                      <div class="col-sm-8">
                        <input type="email" name="email" value="{{$leads->email}}" class="form-control" placeholder="Enter Your Email">
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Additional Number</label>
                      <div class="col-sm-7">
                        <input type="text" maxlength="15" name="mobile" value="{{$leads->mobile}}" class="form-control" placeholder="Enter Your Mobile Number">
                      </div>
                    </div>
                  </div>      
                </div>
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">FollowUp Status</label>
                      <div class="col-sm-7">
                        <select class="custom-select" name="follow_up">
                           <option value="Free trial">Free trial</option>
                           <option value="Call back">Call back</option>
                           <option value="Interested">Interested</option>
                           <option value="Invalid no">Invalid no</option>
                           <option value="NPC">NPC</option>
                           <option value="Paid">Paid</option>  
                        </select>
                      </div>
                    </div>
                  </div>
                </div>
     
                <h4 class="card-title">ADDITIONAL INFORMATION</h4>
              
                <div class="row">
                  <div class="col-md-8">
                    <div class="form-group row">
                      <label class="col-sm-3 col-form-label">Description<span style="color:red;">*</span></label>
                      <div class="col-sm-9">
                        <textarea type="text" name="notes" class="form-control" placeholder="Write Something" required>{{$leads->notes}}</textarea>
                      </div>
                    </div>
                  </div>
                    <br>
                    <br>
                </div>
                <button type="submit" class="btn btn-primary mr-2 ">Update</button>

              </form>
              <div class="col-md-12">
                  <div class="form-group row" style="float: right;">
                    <a href="{{url('/showlead')}}" class="auth-link text-black">Back..
                    </a>
                  </div>
              </div>
            </div>
          </div>
        </div>
      </div>
</main><!-- End #main -->

@endsection