@extends('frontend.layouts.main')
@section('main-container')

<main id="main" class="main">
    @include('cdn')
     <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
     <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
     <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js" integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous"></script>
     <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js" integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous"></script>
     <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
  <div class="container h-100" style="margin-top:100px;width:500px;">
      
<h2>System Default Currency</h2>
<div class="d-flex justify-content-center" >

    <div class="card-body">
         <form method="POST" action="{{url('/storecurrency')}}">
            {{ csrf_field() }}
   
                <div class=" form-outline  mb-3" style="width:300px;">

                     <strong>Currency<span style="color:red;">*</span></strong>
                       <select name="currency" class="form-control mt-1 " required>
                             <option value="" >Select Currency</option>
                             @foreach($allcurr as $curr)
                              @if($symb->id==$curr->id)
                               <option value="" selected>{{$symb->csymbol}} {{$symb->cur_code}} </option>
                              @else
                                <option value="{{$curr->id}}">{{$curr->csymbol}} {{$curr->cur_code}}</option>
                              @endif     
                              @endforeach
                         </select>
                        @error('currency')
                        <div class="alert alert-danger mt-1 mb-1">{{ $message }}</div>
                        @enderror
                    
                </div>
                <button type="submit" class="btn btn-primary">Save</button>
                <!-- Button trigger modal -->
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addcurrency">
                  Add Currency
                </button>

              </form>  
        </div>
       
            <!-- Modal -->
        <form action="{{url('/addnewcurrency')}}" method="post">
                @csrf
            <div class="modal fade" id="addcurrency" tabindex="-1" aria-labelledby="addcurrencyModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                          <div class="modal-header">
                            <h5 class="modal-title" id="addcurrencyModalLabel">Add New Currency</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                          </div>
                          <div class="modal-body">
                            <label>Name</label><input type="text" name="cur_name" class="form-control" placeholder="Currency name" required>
                            <label>Symbol</label><input type="text" name="csymbol" value="" class="form-control" placeholder="Symbol" required>
                           <label>Country</label><input type="text" name="country" class="form-control" placeholder="Country" required>
                            <label>Code</label><input type="text" name="cur_code" class="form-control" placeholder="Code" required>
                          </div>
                          <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Save</button>
                          </div>
                    </div>
                </div>
            </div>
        </form>
</div>

</div>
<div class="mt-4">
    <table class="table table-striped display" id="tabl">
        <thead>
            <tr>
                    <th>S.No</th>
                    <th>Currency</th>
                    <th>Symbol</th>
                    <th>Country</th>
                    <th>Action</th>  
            </tr>
        </thead>
        <tbody>
            @foreach($allcurr as $currency)
            <tr>
                <td>{{$currency->id}}</td>
                <td>{{$currency->cur_code}}</td>
                <td>{{$currency->csymbol}}</td>
                <td>{{$currency->country}}</td>
                <td><button type="button" class="btn btn-info"><a href="{{url('deletecurrency',$currency->id)}}" style="color: white;">Delete</a></button></td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
<script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script type="text/javascript">  
    $(document).ready(function () {
    $('#tabl').DataTable();
});
</script> 

</main>
@endsection     