@extends('frontend.layouts.main')
@section('main-container')
  <main id="main" class="main">
    <div class="pagetitle">
      <div class="row page-titles mx-0">

        <div class="col-sm-6 p-md-0">

            <div class="breadcrumb-range-picker">

                 <h3>Customer</h3>

            </div>

        </div>

        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

             <a href="{{url('/customers')}}" class="btns primary-btn ml-4">

                <span class="btn-icon-left" style="color: white">Back</span>

            </a>

        </div>

    </div>
    </div><!-- End Page Title -->
    <section class="section dashboard">
      <div class="row" style="margin-top: 25px">

        <!-- Left side columns -->
        <div class="col-lg-3">
            <!-- Sales Card -->
            <div class="card info-card sales-card">

                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="text-align-center">
                            @if ($users->profile == null)
                                <div class="rounded-circle border d-flex justify-content-center align-items-center"
                                    style="width: 60px; height: 60px; margin-top: 15px; margin-bottom: 10px;">
                                    <i class="bi bi-person-circle" style="font-size: 60px;"></i>
                                </div>
                            @else
                            <img src="{{ url('public/Image/' . $users->profile) }}" alt="avatar1"
                            class="rounded-circle" style="height: 60px; width: 60px; margin-top: 15px; margin-bottom: 10px;">
                            @endif
                            <p>{{ $users->name }}</p>
                            <p>{{ $users->mobile }}</p>
                            <span class="text-success small pt-1 fw-bold"></span>
                            <span class="text-muted small pt-2 ps-1"></span>
                        </div>
                    </div>
                </div>

            </div>
        </div><!-- End Sales Card -->

        <!-- End Left side columns -->

        <div class="col-lg-9">
            <div class="card">
              <div class="card-body">
                <h5 class="card-title">About<span></span></h5>
                <table class="table">
                  <tbody>
                      <tr>
                          <td><strong>Group:</strong> {{ $users->Group->name ?? 'No Group' }}</td>
                          <td><strong>Email:</strong> {{ $users->email }}</td>
                      </tr>
                      <tr>
                          <td><strong>Role:</strong> {{ $users->role }}</td>
                          <td><strong>D.O.B:</strong> {{ \Carbon\Carbon::parse($users->DOB)->format('d-m-Y') }}</td>
                      </tr>
                      <tr>
                          <td><strong>Status:</strong> {{ $users->status == 1 ? 'Active' : 'Inactive' }}</td>
                          <td><strong>HeadQuater:</strong> {{ $users->HeadQuater->name ?? 'N/A' }}</td>
                      </tr>
                      <tr>
                          <td><strong>State:</strong> {{ $users->State->name ?? 'N/A'  }}</td>
                          <td><strong>City:</strong> {{ $users->City->name ?? 'N/A'  }}</td>
                      </tr>
                      <tr>
                          <td><strong>PinCode:</strong> {{ $users->pincode }}</td>
                          <td><strong>Bank Details:</strong> {!! str_replace('<br />', ' ', strip_tags($users->bank_details)) !!}</td>

                      </tr>
                  </tbody>
              </table>


              </div>
            </div>

          </div><!-- End Right side columns -->


      </div>
      <div class="tab">
        <button class="tablinks" onclick="openCity(event, 'London')">Order</button>
      </div>

      <div id="London" class="tabcontent">
        <h3>Order</h3>
        <table class="table">
            <thead>
              <td><strong>#</strong></td>
              <td><strong>Name</strong></td>
              <td><strong>Customer Name</strong></td>
              <td><strong>Amount</strong></td>
            </thead>

            <tbody>
                @foreach($orders as $key=>$value)
              <tr>
                <td>{{ ++$key }}</td>
                <td>{{ $value->User->name ?? 'No User' }}</td>
                 <td>{{ $value->Customer->name ?? 'No Customer'}}</td>
                 <td>₹ {{ $value->amount }} /-</td>
              </tr>
              @endforeach
            </tbody>

          </table>
      </div>

      <script>
        function openCity(evt, cityName) {
          var i, tabcontent, tablinks;
          tabcontent = document.getElementsByClassName("tabcontent");
          for (i = 0; i < tabcontent.length; i++) {
            tabcontent[i].style.display = "none";
          }
          tablinks = document.getElementsByClassName("tablinks");
          for (i = 0; i < tablinks.length; i++) {
            tablinks[i].className = tablinks[i].className.replace(" active", "");
          }
          document.getElementById(cityName).style.display = "block";
          evt.currentTarget.className += " active";
        }
    </script>

    </section>

  </main><!-- End #main -->

 @endsection


