@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')


<div class="content-body">

    <div class="row page-titles mx-0">

            <div class="col-sm-6 p-md-0">

                <div class="breadcrumb-range-picker">

                    <h3 class="ml-1">Category</h3>

                </div>

            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

                <a href="{{url('category/create')}}">

                    <button type="button" class="btns primary-btn ml-4">

                        <span class="btn-icon-left" style="color: white">
                       + Add Category
                       </span>
                    </button>

                </a>

            </div>

        </div>

    <div class="container-fluid" style="margin-top: 15px">

        @include('flash_msg')

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <form method="GET" action="">

                            <div class="row text-right">

                                <div class="col-md-6"></div>

                                <div class="col-md-4">

                                    <input type="text" class="form-control right-search" name="search" value="{{$request->search}}" placeholder="Search by Category Name">

                                </div>

                                <div class="col-md-2">

                                    <label class="">&nbsp;</label>

                                    <button type="submit" class="tns primary-btn">Search</button>

                                </div>

                            </div>

                        </form>

                        <hr>

                        <div class="table-responsive">

                            <table class="table table-border table-hover table-sm" >

                                <thead>

                                    <tr>

                                        <th>#</th>

                                        <th>IMAGE</th>

                                        <th>CATEGORY NAME</th>

                                        <th class="text-right">ACTION</th>

                                    </tr>

                                </thead>

                                 <tbody>

                                    @if(!empty($category_masters))

                                    @foreach($category_masters as $key=>$value)

                                    <tr>

                                        <td>{{ ++$key }}</td>


                                        <td>
                                            @if($value->image)
                                                <img src="{{ url('/uploads/category/'.$value->image) }}" height="50" width="50">
                                            @else
                                                <img src="{{ url('/uploads/category/default.jpg') }}" height="50" width="50">
                                            @endif
                                        </td>


                                        <td>{{ $value->name }}</td>

                                        <td class="text-right">

                                            <a href="{{ route('category.edit',encrypt($value->id)) }}">
                                            <button type="button" class="btns success-btn btn-sm" title="Edit" alt="Edit"><i class="fas fa-edit"></i> 
                                            </button>
                                             </a>


                                            <a href="{{ route('category.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure?')">
                                            <button type="button" class="btns success-btn btn-sm" title="Delete" alt="Delete"><i class="fas fa-trash-alt"></i>
                                            </button>
                                            </a>

                                            </td>

                                        </tr>

                                    @endforeach

                                        @if ($category_masters->count() == 0)

                                        <tr class="text-center">

                                            <td colspan="6">No Category Master to display.</td>

                                        </tr>

                                        @endif

                                    @endif

                                </tbody>

                                <tfoot>

                                    <tr>

                                        <th>#</th>

                                        <th>Image</th>

                                        <th>Category Name</th>

                                        <th class="text-right">Action</th>

                                    </tr>

                                </tfoot>

                            </table>

                        </div>

                        <div class="text-left float-left mt-1">

                             <p>Displaying {{$category_masters->count()}} of {{ $category_masters->total() }}categories.</p>

                        </div>

                        <div class="pagination">
                            <ul class="pagination-list">
                                @if ($category_masters->currentPage() > 1)
                                    <li class="pagination-item">
                                        <a href="{{ $category_masters->appends(request()->all())->previousPageUrl() }}" class="pagination-link">&lt;</a>
                                    </li>
                                @endif

                                @if ($category_masters->currentPage() > 3)
                                    <li class="pagination-item">
                                        <a href="{{ $category_masters->appends(request()->all())->url(1) }}" class="pagination-link">1</a>
                                    </li>
                                    <li class="pagination-item disabled">
                                        <span class="pagination-link">...</span>
                                    </li>
                                @endif

                                @foreach(range(max(1, $category_masters->currentPage() - 2), min($category_masters->lastPage(), $category_masters->currentPage() + 2)) as $page)
                                    <li class="pagination-item {{ $page == $category_masters->currentPage() ? 'active' : '' }}">
                                        <a href="{{ $category_masters->appends(request()->all())->url($page) }}" class="pagination-link">{{ $page }}</a>
                                    </li>
                                @endforeach

                                @if ($category_masters->currentPage() < $category_masters->lastPage() - 2)
                                    <li class="pagination-item disabled">
                                        <span class="pagination-link">...</span>
                                    </li>
                                    <li class="pagination-item">
                                        <a href="{{ $category_masters->appends(request()->all())->url($category_masters->lastPage()) }}" class="pagination-link">{{ $category_masters->lastPage() }}</a>
                                    </li>
                                @endif

                                @if ($category_masters->hasMorePages())
                                    <li class="pagination-item">
                                        <a href="{{ $category_masters->appends(request()->all())->nextPageUrl() }}" class="pagination-link">&gt;</a>
                                    </li>
                                @endif
                            </ul>
                        </div>



                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

</main><!-- End #main -->
 @endsection
