@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>View Branch</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{route('company.index')}}" class="btns primary-btn ml-4">

            <span class="btn-icon-left" style="color: white">Back</span>

        </a>

    </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="row">
                        
                        <div class="mt-2 col-lg-4"><b>Branch Name</b></div><div class="mt-2 col-lg-8"> : {{$company->name}}</div>
                        <div class="mt-2 col-lg-4"><b>GST</b></div><div class="mt-2 col-lg-8"> : {{$company->GST}}</div>
                        <div class="mt-2 col-lg-4"><b>State</b></div><div class="mt-2 col-lg-8"> : {{$company->state_info?$company->state_info->name:''}}</div>
                        <div class="mt-2 col-lg-4"><b>City</b></div><div class="mt-2 col-lg-8"> : {{$company->city_info?$company->city_info->name:''}}</div>
                        <div class="mt-2 col-lg-4"><b>Owner Name</b></div><div class="mt-2 col-lg-8"> : {{$user->name}}</div>
                        <div class="mt-2 col-lg-4"><b>Mobile</b></div><div class="mt-2 col-lg-8"> : {{$user->mobile}}</div>
                        <div class="mt-2 col-lg-4"><b>Email</b></div><div class="mt-2 col-lg-8"> : {{$user->email}}</div>
                        <div class="mt-2 col-lg-4"><b>DOB</b></div><div class="mt-2 col-lg-8"> : {{$user->DOB}}</div>
                        <div class="mt-2 col-lg-4"><b>Pincode</b></div><div class="mt-2 col-lg-8"> : {{$user->pincode}}</div>
                        <div class="mt-2 col-lg-4"><b>Group</b></div><div class="mt-2 col-lg-8"> : {{$user->Group?$user->Group->name:''}}</div>
                        <div class="mt-2 col-lg-4"><b>Bank Details</b></div><div class="mt-2 col-lg-8"> : {!!$user->bank_details!!}</div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

</main><!-- End #main -->

@endsection
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
 <script>
    $(document).ready(function() {
        $('#state-dropdown').on('change', function() {
            var state_id = this.value;
            $("#city-dropdown").html('');
            $.ajax({
                url:"{{url('get-cities-by-state')}}",
                type: "POST",
                data: {
                    state_id: state_id,
                    _token: '{{csrf_token()}}'
                },
                dataType : 'json',
                success: function(result) {
                    $.each(result.cities, function(key, value) {
                        $("#city-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
                    });
                }
            });
        });
    });
</script>
