@extends('backend.company.layouts.main')

@section('main-container')

<main id="main" class="main">
@include('cdn')
    <div class="content-body">

        <div class="row page-titles mx-0">

        <div class="col-sm-6 p-md-0">

            <div class="breadcrumb-range-picker">

                 <h4>Manage Permission</h4>

            </div>

        </div>

        <div class="col-sm-6 p-md-0 justify-content-sm-end mb-2 mt-sm-0 d-flex">

            <a href="{{ route('company.roles') }}">

                <button type="button" class="btns success-btn btn-sm">

                    <i class="fas fa-arrow-left"></i> Back

                </button>

            </a>

        </div>

    </div>

        <div class="container-fluid">

            @include('flash_msg')

            <div class="row">

                <div class="">

                    <div class="card">

                        <div class="card-body">

                             <form action="{{ route('seller.assign.permission') }}" method="POST" id="vendor_register">
                                @csrf

                                <div class="form-group row">
                                    <div class="col-lg-6">
                                        <label>Role<span class="text-danger">*</span></label>

                                        <select class="form-control select2" name="role_id" required onchange="changeRole(this.value)">
                                            <option value="">Select Role</option>
                                            @foreach($roles as $role)
                                            <option value="{{$role->id}}" {{$role_id==$role->id ? 'selected': ''}}>{{str_replace('_','',str_replace(Auth::user()->company_id,'',$role->name))}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="row mt-4 ">
                                    <table class="permissionTable table">
                                        <th>
                                            {{__('Section')}}
                                        </th>
                            
                                        <th>
                                            <label>
                                                {{__('Select All') }}
                                            </label>
                                        </th>
                            
                                        <th>
                                            {{__("Available permissions")}}
                                        </th>
                            
                            
                                       
                                        <tbody class="role-permission">
                                           @foreach($custom_permission as $key => $group)
                                            <tr>
                                                <td>
                                                    <b>{{ucfirst(str_replace('_','',str_replace(Auth::user()->company_id,'',$key)))}}</b>
                                                </td>
                                                <td width="30%">
                                                    <label>
                                                        <input class="selectall" onclick="selectAll(this.value)" value="{{$key}}" type="checkbox">
                                                        {{__('Select All') }}
                                                    </label>
                                                </td>
                                                <td>
                                                    
                                                    @forelse($group as $permission)
                                                        
                                                       <label>
                                                            @if(in_array($permission->id, $permissionIds))
                                                               <input name="permissions[]" class="permissioncheckbox {{$key}}" type="checkbox" checked value="{{ $permission->id }}">
                                                               &nbsp; {{ucfirst(str_replace('_','',str_replace(Auth::user()->company_id,'',$permission->name)))}} &nbsp;&nbsp;
                                                            @else
                                                                <input name="permissions[]" class="permissioncheckbox {{$key}}" type="checkbox" value="{{ $permission->id }}">
                                                               &nbsp; {{ucfirst(str_replace('_','',str_replace(Auth::user()->company_id,'',$permission->name)))}} &nbsp;&nbsp;
                                                            @endif
                                                       </label>
                            
                                                    @empty
                                                        {{ __("No permission in this group !") }}
                                                    @endforelse
                            
                                                </td>
                            
                                            </tr>
                                           @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-center">
                                    <button type="submit" class="btns primary-btn btn-sm">Update</button>
                                </div>

                            </form>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</main>
<script type="text/javascript">
    function changeRole(argument) {
        
    }
</script> 

<script>
    function selectAll(argument) {
       
        var cls = "."+argument;

        if($(cls).prop('checked')==true){
           
            $(cls).prop('checked', false);
        } else {
           
            $(cls).prop('checked', true); 
        }
        
    }
</script>

@endsection
