@extends('backend.company.layouts.main')

@section('main-container')

<main id="main" class="main">
@include('cdn')
    <div class="content-body">

        <div class="row page-titles mx-0">

        <div class="col-sm-6 p-md-0">

            <div class="breadcrumb-range-picker">

                 <h4>Add Role & Permission</h4>

            </div>

        </div>

        <div class="col-sm-6 p-md-0 justify-content-sm-end mb-2 mt-sm-0 d-flex">
            
            <a href="{{ route('company.roles') }}">

                <button type="button" class="btns success-btn btn-sm">

                    <i class="fas fa-arrow-left"></i> Back

                </button>

            </a>

        </div>

    </div>

        <div class="container-fluid">

            @include('flash_msg')

            <div class="row">

                <div class="">

                    <div class="card">

                        <div class="card-body">

                            <form action="{{ route('seller.role.store') }}" method="POST">
                                @csrf

                                <div class="form-group row mt-4">
                                    <div class="col-lg-6">
                                        <label>Role<span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="role" placeholder="Enter Role" required>
                                    </div>
                                </div>
                                <div class="row mt-4 form-group">
                                   
                                    <table class="permissionTable table">
                                        <th>
                                            {{__('Section')}}
                                        </th>
                            
                                        <th>
                                            <label>
                                                {{__('Select All') }}
                                            </label>
                                        </th>
                            
                                        <th>
                                            {{__("Available permissions")}}
                                        </th>
                            
                            
                                       
                                        <tbody>
                                           @foreach($custom_permission as $key => $group)
                                            <tr>
                                                <td>
                                                    <b>{{ucfirst(str_replace('_','',str_replace(Auth::user()->company_id,'',$key)))}}</b>
                                                </td>
                                                <td width="30%">
                                                    @if($key)
                                                    <label>
                                                        <input class="selectall" onclick="selectAll(this.value)" value="{{$key}}" type="checkbox">
                                                        {{__('Select All') }}
                                                    </label>
                                                    @endif
                                                </td>
                                                <td>
                                                    
                                                    @forelse($group as $permission)
                            
                                                       <label>
                                                           <input name="permissions[]" class="permissioncheckbox {{$key}}" type="checkbox" value="{{ $permission->id }}">
                                                           &nbsp; {{ucfirst(str_replace('_','',str_replace(Auth::user()->company_id,'',$permission->name)))}} &nbsp;&nbsp;
                                                       </label>
                            
                                                    @empty
                                                        {{ __("No permission in this group !") }}
                                                    @endforelse
                            
                                                </td>
                            
                                            </tr>
                                           @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-center">
                                    <button type="submit" class="btns primary-btn btn-sm">Submit</button>
                                </div>

                            </form>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</main>
<script>
    function selectAll(argument) {
       
        var cls = "."+argument;

        if($(cls).prop('checked')==true){
           
            $(cls).prop('checked', false);
        } else {
           
            $(cls).prop('checked', true); 
        }
        
    }
</script>

@endsection
