@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Branch</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{route('company.create')}}" class="btns primary-btn ml-4">

            <span class="btn-icon-plus" style="color: white">Add</span>

        </a>

    </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="table-responsive">

                        <table class="table table-striped" id="tabl">
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Owner</th>

                                    <th>Location</th>

                                    <th>GST</th>

                                    <th>Action</th>

                                </tr>

                            </thead>

                            <tbody>
                                @if(!empty($datas))
                                    @foreach($datas as $key=>$value)
                                     <tr>
                                       <td> {{ ++$key }} </td>
                                       <td> {{ $value->name }} </td>
                                       <td> {{ $value->user?$value->user->name:'' }} </td>
                                       <td> 
                                            <small>
                                                City : {{ $value->city_info->name ?? 'No City' }} <br>
                                                State : {{ $value->state_info->name ?? 'No State' }} <br>
                                                Country : {{ $value->country_info->name ?? 'No Country' }} 
                                            </small>
                                       </td>
                                       <td> {{ $value->GST }} </td>

                                        <td class="text-right">

                                            <a href="{{ url('company/'.$value->id) }}">
                                                <button type="button" class="btns success-btn btn-sm" title="View More" alt="View More">
                                                    <i class="fas fa-eye"></i> 
                                                </button>
                                            </a>


                                             <a href="{{ url('company/'.$value->id.'/edit') }}">
                                            <button type="button" class="btns success-btn btn-sm" title="Edit" alt="Edit"><i class="fas fa-edit"></i> 
                                            </button>
                                             </a>

                                            <a href="{{ route('delete.company',$value->id) }}" onclick="return confirm('Are you sure?')">
                                            <button type="button" class="btns success-btn btn-sm" title="Delete" alt="Delete"><i class="fas fa-trash-alt"></i>
                                            </button>
                                            </a>

                                        </td>

                                     </tr>
                                    @endforeach
                                @endif

                               </tbody>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
<script type="text/javascript">
   $(document).ready(function () {
    var table = $('#tabl').DataTable({
      
      responsive: true
    });

    new $.fn.dataTable.FixedHeader( table );
});
</script>
<script type="text/javascript">
       $("document").ready(function(){
        setTimeout(function()
        {
            $("div.alert").remove();

        }, 3000);

       });

</script>
@endsection
