@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Edit Company</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{route('company.index')}}" class="btns primary-btn ml-4">

            <span class="btn-icon-left" style="color: white">Back</span>

        </a>

    </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-2"></div>

        <div class="col-8">

            <div class="card">

                <div class="card-body">

                    <form action="{{route('update.company')}}" method="POST" class="form-sample" enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <input type="hidden" name="id" value="{{ $data->id }}">

                        <div class="form-group">

                            <label>Company <span class="text-danger">*</span></label>

                            <input type="text" class="form-control" name="company_name" value="{{$data->name}}" required placeholder="Enter Company Name">
                         
                        </div>
                            
                        <div class="form-group">

                            <label>Owner Name <span class="text-danger">*</span></label>

                            <input type="text" class="form-control" name="name" value="{{$data->user?$data->user->name:''}}" required placeholder="Enter Owner Name">
                         
                        </div>

                        <div class="form-group">

                            <label>Email <span class="text-danger">*</span></label>

                            <input type="email" class="form-control" name="email" value="{{$data->user?$data->user->email:''}}" required placeholder="Enter Email">
                         
                        </div>


                        <div class="form-group">
                            
                            <label for="state">Role</label>
                            
                            <select class="form-control" id="state-dropdown" name="role" required>
                                
                                <option value="">Select Role</option>
                                @foreach ($roles as $role)
                                    @if($data->user && $data->user->role && $data->user->role==$role->name)
                                    <option value="{{ $role->name }}" selected>{{ $role->name }}</option>
                                    @else
                                    <option value="{{ $role->name }}">{{ $role->name }}</option>
                                    @endif
                                @endforeach
                            
                            </select>
                        
                        </div>
                            

                        <div class="text-center">
                            <input type="submit" value="Update" class="btn btn-primary">
                        </div>

                    </form>

                </div>

            </div>

        </div>

        <div class="col-2"></div>

    </div>

</div>

</main><!-- End #main -->

@endsection
