@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

 <script src = "https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>

 <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
 
<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Add Branch</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{route('company.index')}}" class="btns primary-btn ml-4">

            <span class="btn-icon-left" style="color: white">Back</span>

        </a>

    </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="{{route('store.company')}}" method="POST" class="form-sample" enctype="multipart/form-data">
                        {{ csrf_field() }}

                        <div class="row">
                                
                            <div class="col-lg-6">
                                
                                <div class="form-group">

                                    <label>Branch Name <span class="text-danger">*</span></label>

                                    <input type="text" class="form-control" name="company_name" value="{{old('company_name')}}" required placeholder="Enter Branch Name">
                                 
                                </div>

                            </div>

                            <div class="col-lg-6">

                                <div class="form-group">

                                    <label>Owner Name <span class="text-danger">*</span></label>

                                    <input type="text" class="form-control" name="name" value="{{old('name')}}" required placeholder="Enter Owner Name">
                                 
                                </div>
                                
                            </div>

                            <div class="col-lg-6">

                                <div class="form-group">

                                    <label>Email <span class="text-danger">*</span></label>

                                    <input type="email" class="form-control" name="email" value="{{old('email')}}" required placeholder="Enter Email">
                                 
                                </div>
                                
                            </div>

                            <div class="col-lg-6">

                                <div class="form-group">

                                    <label>Mobile <span class="text-danger">*</span></label>

                                    <input type="number" class="form-control" name="mobile" value="{{old('mobile')}}" required placeholder="Enter Mobile">
                                 
                                </div>
                                
                            </div>

                            <div class="col-lg-6">

                                <div class="form-group">
                                    <label for="state">Role <span class="text-danger">*</span></label>
                                    <select class="form-control" name="role" required>
                                        <option value="">Select Role</option>
                                        @foreach ($roles as $role)
                                        <option value="{{ $role->name }}">{{ $role->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                            </div>

                            <div class="col-lg-6">

                                <div class="form-group">
                                    <label for="state">State</label>
                                    <select class="form-control" id="state-dropdown" name="state">
                                        <option value="">Select State</option>
                                        @foreach ($states as $state)
                                        <option value="{{ $state->id }}">{{ $state->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                            </div>

                            <div class="form-group col-lg-6">
                                <label for="city">City</label>
                                <select class="form-control" id="city-dropdown" name="city">
                                    <option value="">Select City</option>
                                </select>
                            </div>

                            <div class="col-lg-6">
                                
                                <div class="form-group">
                                    <label for="address">Address</label>
                                    <input type="address" name="address" class="form-control" value="{{ old('address') }}" placeholder="Enter Address" required>
                                </div> 

                            </div>

                            <div class="col-lg-6">
                                
                                <div class="form-group">                                
                                    <label>Password</label>
                                    <input type="password" name="password" class="form-control mt-2" value="{{ old('password') }}" placeholder="Enter Password" required>
                                </div>

                            </div>

                        </div>

                        <div class="text-center">
                            <input type="submit" value="Submit" class="btn btn-primary">
                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

</div>

</main><!-- End #main -->

@endsection
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
 <script>
    $(document).ready(function() {
        $('#state-dropdown').on('change', function() {
            var state_id = this.value;
            $("#city-dropdown").html('');
            $.ajax({
                url:"{{url('get-cities-by-state')}}",
                type: "POST",
                data: {
                    state_id: state_id,
                    _token: '{{csrf_token()}}'
                },
                dataType : 'json',
                success: function(result) {
                    $.each(result.cities, function(key, value) {
                        $("#city-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
                    });
                }
            });
        });
    });
</script>
