<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fileimports', function (Blueprint $table) {
            $table->id();
            $table->integer('Branchid')->unsigned();
            $table->foreign('Branchid')->references('id')->on('users');
            $table->string('Name')->nullable();
            $table->string('FileName')->nullable();
            $table->string('SystemFileName')->nullable();
            $table->string('Description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fileimports');
    }
};
