<?php

namespace App\Http\Controllers\Seller;

use Auth;
use App\Models\Company;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Spatie\Permission\Models\Permission;

class RolesController extends Controller
{
    public function index(Request $request)
    {
        $company = Company::where('user_id',Auth::user()->id)->first();

        $data['roles'] = Role::orderBy('id', 'DESC')->where('company_id',$company->id)->get();

        return view('backend.company.roles.index',$data);
    }

    public function create()
    {
        $data['permissions']    =   Permission::where('company_id',Auth::user()->company_id)->get();

        $role_permission = Permission::where('company_id',Auth::user()->company_id)->get();

        $custom_permission = array();

        foreach($role_permission as $per){

            $key = substr($per->name, 0, strpos($per->name, ".")); 

            if(str_starts_with($per->name, $key)){
                $custom_permission[$key][] = $per;
            }
            
        }
     
        $data['custom_permission'] = $custom_permission;

        return view('backend.company.roles.create',$data);
    }

    public function store(Request $request)
    {
        $request->validate([
            'role' => 'required',
        ]);

        $role_name = Auth::user()->company_id.'_'.$request->role;
        
        if(Role::where('company_id',Auth::user()->company_id)->where('name', $role_name)->count()>0){
            return redirect()->back()->with('error','This role already excited.');
        }
        
       $role = Role::create(['name' => $role_name,'company_id' => Auth::user()->company_id]);

        if($request->permissions){
            foreach ($request->permissions as $key => $value) {
                $role->givePermissionTo($value);
            }
        }
        return redirect()->route('company.roles')->with('success','Role created successfully.');
    }

    public function permissions($roleid)
    {
        $company_id             =   Auth::user()->company_id;
        $data['role_id']        =   $roleid;
        $data['roles']          =   Role::where('company_id',$company_id)->get();
        $data['permissions']    =   Permission::where('company_id',$company_id)->get();
        $permissionIds = [];
        $dats = Role::where('roles.id', $data['role_id'])
                ->with('permissions')
                ->first();
               
        if($dats['permissions']){
            foreach ($dats['permissions'] as $key => $value) {
                array_push($permissionIds, $value->id);
            }
        }
         // return $permissionIds;
        $data['permissionIds'] = $permissionIds;

        $role_permission = Permission::where('company_id',$company_id)->get();

        $custom_permission = array();

        foreach($role_permission as $per){

            $key = substr($per->name, 0, strpos($per->name, ".")); 

            if(str_starts_with($per->name, $key)){
                $custom_permission[$key][] = $per;
            }
            
        }
   
        $data['custom_permission'] = $custom_permission;

        return view('backend.company.roles.permissions',$data);
    }

    public function update_assign_permission(Request $request)
    {
        $request->validate([
            'role_id' => 'required',
        ]);

        $role = Role::find($request->role_id);

        $role->save();

        $role->syncPermissions($request->permissions);

        return redirect()->route('company.roles')->with('success','Role update successfully.');
    }
}
