<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Route;

class RoleController extends Controller
{


    public function index(Request $request)
{
    $permissions = Permission::get();

    if ($request->search) {
        $roles = Role::orderBy('id', 'DESC')->where('name', 'like', '%' . $request->search . '%')->get();
    } else {
        $roles = Role::orderBy('id', 'DESC')->get();
    }

    return view("frontend.rolespage", compact('roles', 'permissions'))->with('request', $request);
}



    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        \Artisan::call('cache:clear');

        $role = Role::find($request->role_id);

        // $role->givePermissionTo($request->permissions);
        $role->syncPermissions($request->permissions);
        return redirect('/addroles')->with('success','Permission Updated Successfully');
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        //
    }


    public function destroy($id)
    {
        //
    }

    public function submitRole(Request $request)
    {
        $params['name']=$request->r_name;
        $role=Role::create($params);
        if($request->permission)
        {
            foreach ($request->permission as $key => $value)
            {
                $role->givePermissionTo($value);
            }
        }
        return redirect()->route('addroles')->with('success','Role Create Successfully');
    }

    public function roleEdit($id,Request $request)
    {
        Role::where('id',$id)->
        update([
            'name'=>$request->name
        ]);
        return redirect()->route('addroles')->with('success','Role update successfully');
    }

    public function delete_Role($id)
    {
        $roles=Role::find($id);
        $roles->delete();
        return redirect()->route('addroles')->with('success','Role delete successfully');
    }

    public function show_permission($id, Request $request)
    {
        $roles=Role::find($id);
        Session::put('roles',$roles);
        return redirect('/permis');
    }

    public function ChangeRole($id)
    {
    $roleId=$id;
    $rolePermissions = array();
    $permissions=Permission::all();
    $role=Role::where('id',$roleId)->with('permissions')->first();
    if ($role['permissions']){
        foreach ($role['permissions'] as $key=>$value){
            $rolePermissions[]=$value->id;
        }
    }
    $html='';
    if(!empty($permissions)){
        foreach ($permissions as $permission){
              if(in_array($permission->id, $rolePermissions)){
                $html.='<div class="col-sm-3 form-check-inline">
                       <input class="form-check-input p-2" type="checkbox" name="permission[]" id="inlineCheckbox1" value="'.$permission->id.'" checked>
                      <label class="form-check-label p-2" for="inlineCheckbox1" style="text-transform:capitalize;">'.$permission->name.'</label>
                     </div>';
              }else{
                    $html.='<div class="col-sm-3 form-check-inline">
                        <input class="form-check-input p-2" type="checkbox" name="permission[]" id="inlineCheckbox1" value="'.$permission->id.'">
                      <label class="form-check-label p-2" for="inlineCheckbox1" style="text-transform:capitalize;">'.$permission->name.'</label>
                     </div>';
                 }
        }
    }
    else{
        $html='';
    }
    return response()->json($html);
   }
}
