<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Location;

class LocationController extends Controller
{
   
    public function index()
    {
        $data['datas'] = Location::orderBy('Id', 'DESC')->get();

        return view('location.index',$data);
    }

    public function create()
    {
        return view('location.create');
    }


    public function store(Request $request)
    {
        $this->validate($request,[
            'name'              => 'required',
        ]);

        $params['name']             = $request->name;

        $res = Location::create($params);
        if($res){
            return redirect()->route('locations')->with('success','Location Created Successfully');
        } else {
            return redirect()->back()->with('error','Try Again');
        }
    }

   
    public function edit($id)
    {

        $id=decrypt($id);

        $location          =   Location::find($id);
        $data['location']   =   $location;

        return view('location.edit',$data);
    }

   
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $location = Location::find($id);
        if (!$location) {
            return redirect()->back()->with('error', 'Location not found');
        }

        $params['name'] = $request->name;
        $location->update($params);

        return redirect()->route('locations')->with('success', 'Location Updated Successfully');
    }


  
    public function destroy($id)
    {
        $id=decrypt($id);

        $location=Location::find($id);

        $location->delete();

        return redirect()->back()->with('error','Location deleted successfully.');
    }




     public function location_active($id){
            $data=Location::find($id);
            if($data){
                if($data->status=='1'){
                    $status='0';
                }else{
                    $status='1';
                }
                $data->update([
                    'status'=>$status
                ]);
                return back()->with('success', 'Status Update successfully.');
            } else {
                return back()->with('error', 'Try Again.');
            }
            

        }
}
