<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use App\Models\{User,Role,Group,State,City,Company};

class CompanyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
        if(Auth::check() && Auth::user()->role=='Branch'){

            $data['add_products']   = [];
            $data['suggestions']    = [];
            $data['orders']         = [];
            $data['users']          = [];
            $company                = Company::where('user_id',Auth::user()->id)->first();
            $logo                   = $company->logo;
            Session::put('logo', $logo);
            
            return view('backend.company.dashboard',$data);
        } elseif (Auth::check() && Auth::user()->role=='Admin') {
            $data['datas']          = Company::all();
            return view('backend.company.index',$data);
        } else {
            return redirect()->back();
        }
        
    }

    public function create()
    {
        $data['roles'] = Role::whereNull('company_id')->get();
        $data['states']     = State::where('country_id','101')->get();

        return view('backend.company.create',$data);
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'company_name'  => 'required',
            'name'          => 'required',
            'email'         => 'required|email|unique:users,email',
        ]);

        $company['name']    = $request->company_name;
        $company['state']   = $request->state;
        $company['city']    = $request->city;
        $company['address'] = $request->address;
        $company['country'] = '101';
        $company['status']  = '1';
        $comp = Company::create($company);

        $params['name']         =   $request->name;
        $params['email']        =   $request->email;
        $params['mobile']       =   $request->mobile;
        $params['role']         =   str_replace('_','',str_replace($comp->id,'',$request->role));
        $params['password']     =   Hash::make($request->password);
        $params['state']        =   $request->state;
        $params['city']         =   $request->city;
        $params['company_id']   =   $comp->id;
       
        $user=User::create($params);
        $user->assignRole($request->role);

        $u_comp['user_id'] = $user->id;
        Company::whereId($comp->id)->update($u_comp);

        return redirect()->route('company.index')->with('success','Company Updated Successfully');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function shop()
    {
        $company_id = Auth::check()?Auth::user()->company_id:'';

        $company = Company::find($company_id);

        if($company){
            $data['company']    = $company;
            $user               = User::where('company_id',$company->id)->first();
            $data['groups']     = Group::where('company_id',Auth::user()->company_id)->get();
            $data['states']     = State::where('country_id','101')->get();
            $data['user']       = $user;
            $data['cities']     = City::where('state_id',$user->state)->get();
            return view('seller.shop_info',$data);            
        } else {
            return redirect()->back()->with('error','Company not found');
        }
    }

    public function show($id)
    {
        $company_id = $id;

        $company = Company::find($company_id);

        if($company){
            $data['company']    = $company;
            $user               = User::where('company_id',$company->id)->first();
            $data['user']       = $user;
            return view('backend.company.view',$data);             
        } else {
            return redirect()->back()->with('error','Company not found');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function seller_user_setting_update(Request $request, $id)
    {
        $this->validate($request,[
            'name'      => 'required',
            'mobile'    => 'required',
            'email'     => 'required',
        ]);

        $user = User::find($id);

        if($request->file('profile')){
            $file       = $request->file('profile');
            $filename   = date('YmdHi').$file->getClientOriginalName();
            $file->move(public_path('public/Image'), $filename);
            $params['profile']   =   $filename;
        }

        $params['name']         =   $request->name;
        $params['email']        =   $request->email;
        $params['mobile']       =   $request->mobile;
        $params['DOB']          =   $request->dob;
        $params['group']        =   $request->group;
        $params['state']        =   $request->state;
        $params['city']         =   $request->city;
        $params['pincode']      =   $request->pincode;
        $params['bank_details'] =   $request->bank_details;
        $user->update($params);
        return redirect()->back()->with('success','User Updated Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function seller_company_setting_update(Request $request, $id)
    {
        $this->validate($request,[
            'name'      => 'required',
        ]);

        $user = Company::find($id);

        if($request->file('logo')){
            $file       = $request->file('logo');
            $filename   = date('YmdHi').$file->getClientOriginalName();
            $file->move(public_path('public/Image'), $filename);
            $params['logo']   =   $filename;
        }

        $params['name']       =   $request->name;
        $params['GST']        =   $request->GST;
        $params['state']      =   $request->state;
        $params['city']       =   $request->city;
        $params['address']    =   $request->address;
        
        $user->update($params);
        return redirect()->back()->with('success','Company Updated Successfully');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['data'] = Company::find($id);
        $data['roles'] = Role::whereNull('company_id')->get();
        return view('backend.company.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $this->validate($request,[
            'company_name'  => 'required',
            'name'          => 'required',
            // 'email'         => 'required|email|unique:users,email,'.$request->email,
        ]);

        $company = Company::find($request->id);
        $company->name = $request->company_name;
        $company->save();

        $user = User::find($company->user_id);
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role = $request->role;
        $user->save();

        return redirect()->route('company.index')->with('success','Company Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        User::where('company_id',$id)->delete();
        Role::where('company_id',$id)->delete();
        Company::where('id',$id)->delete();
        return redirect()->back()->with('error','Company Deleted Successfully');
    }
}
