<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\{Company,Currency,AllCurrency,Source,Group,GroupUsers,ServiceInvoice,Service_Invoice_History,AddProduct,Suggestion,Order,Complain,State};
use Hash;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use App\Rules\MobileNumberValidation;
use Illuminate\Support\Facades\Crypt;
class AdminController extends Controller
{
    public function index(Request $request)
    {
        $id=$request->id;
        $inv_details=ServiceInvoice::find($id);
        $inv_history=Service_Invoice_History::where('inv_id',$id)->get();
        $companylogo=Session::get('data');
        return view('frontend.components-invoice',compact('inv_details','companylogo','inv_history'));

    }

    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        //
    }


    public function update($id,Request $request)
    {
         if($request->logo)
        {
            if($request->file('logo')){
                $file= $request->file('logo');
                $filename= date('YmdHi').$file->getClientOriginalName();
                $file-> move(public_path('public/Image'), $filename);
            }

            Company::where('id',$id)->
            update([
                'name'=>$request->name,
                'city'=>$request->city,
                'state'=>$request->state,
                'country'=>$request->country,
                'address'=>$request->address,
                'GST'=>$request->GST,
                'logo'=>$filename,
            ]);
            return redirect()->route('users-profile')->with('success','Company Profile Update Successfully');

        }
          Company::where('id',$id)->
          update([
            'name'=>$request->name,
            'city'=>$request->city,
            'state'=>$request->state,
            'country'=>$request->country,
            'address'=>$request->address,
            'GST'=>$request->GST,
          ]);

         return redirect()->route('users-profile')->with('success','Company Profile Update Successfully');
    }


    public function update_profile(Request $request)
    {
        
        if($request->from=='profile'){
            if($request->file('profile')){
                $file= $request->file('profile');
                $filename= date('YmdHi').$file->getClientOriginalName();
                $file-> move(public_path('public/Image'), $filename);
            }
            $params['profile'] = $filename;
            User::whereId(Auth::check()?Auth::user()->id:'')->update($params);
            return redirect()->back()->with('success','Profile Update Successfully');
        } else {
          
            if(Hash::check($request->password, auth()->user()->password)){
                
                if($request->newpassword==$request->renewpassword){
                    $params['password'] = Hash::make($request->newpassword);
                    User::whereId(Auth::check()?Auth::user()->id:'')->update($params);
                    return redirect()->back()->with('success','Password Changed Successfully');
                } else {
                    return redirect()->back()->with('error','Password and new password does not match.');
                }
            } else {

                return redirect()->back()->with('error','Your current password does not match.');
            }
        }
    }

    public function signIn(Request $request)
    {
        $email=$request->email;
        $password=$request->password;
        if (Auth::attempt(['email'=>$email,'password'=>$password]))
        {
        return redirect('/index');
        }
            
        else
        {
            return redirect('/')->with('success','something went wrong..');
        }
    }



    public function register_store(Request $request)
    {
        $this->validate($request,[
            'company_name' => 'required',

            'email' => 'required|string|email|unique:users',

            'mobile' => 'required|unique:users',

            'password' => 'required|min:6'
        ]);

        $params['name']             = $request->name;
        $params['email']            = $request->email;
        $params['password']         = Hash::make($request->password);
        $params['state']            = $request->state;
        $params['city']             = $request->city;
        $params['mobile']           = $request->mobile;
        $params['address']          = $request->address;
        $params['role']             = 'Company';
        $user = User::create($params);

        if ($user) {

            $company['user_id']     = $user->id;
            $company['name']        = $request->company_name;
            $company['state']       = $request->state;
            $company['city']        = $request->city;
            $company['country']     = 101;
            $company['address']     = $request->address;
            $company['status']      = 1;

            $comp = Company::create($company);

            $user->company_id = $comp->id;
            $user->save();

            Auth::login($user);

            return redirect()->route('company.dashboard')->with('success','Welcome Login Successfully');
        } else {
            return redirect()->back()->with('warning','something went wrong..');
        }
        
    }

    public function create_company()
    {
        $companies=Company::first();
        $logo=$companies->logo;
        Session::put('logo',$logo);
        $states = State::get(["name", "id"]);
        return view('seller.create_shop',compact('states'));
    }

    public function Dashboard(Request $request)
    {
        $companies = Company::first(); // Use first() to get a single company
        $users = User::whereHas('roles', function ($query) {
            $query->where('name', 'Customer');
        })->get();

        $logo = optional($companies)->logo;

        Session::put('logo', $logo);
        
        return view('frontend.index', compact('users'));
    }


   public function Currencyfun(Request $request)
   {
     $var=Currency::get()->first();
     $symb=AllCurrency::where('id',$var->currency_id)->first();
     $allcurr=AllCurrency::all();
     return view('frontend.currency-pages',compact('symb','allcurr'));
   }

   public function SetCurrency(Request $request)
   {
    $curr=Currency::get()->first();
    if($curr){
         Currency::where('id',$curr->id)->
         update([
        'currency_id'=>$request->currency,
         ]);
     }
     else{

         $params['currency_id']=$request->currency;
         Currency::create($params);

     }
     $var=Currency::get()->first();
     $symb=AllCurrency::where('id',$var->currency_id)->first();
     $allcurr=AllCurrency::all();
     return view('frontend.currency-pages',compact('symb','allcurr'));

   }

   public function AddCurrency(Request $request)
   {
    $params['cur_name']=$request->cur_name;
    $params['csymbol']=$request->csymbol;
    $params['country']=$request->country;
    $params['cur_code']=$request->cur_code;
    AllCurrency::create($params);
    $var=Currency::get()->first();
    $symb=AllCurrency::where('id',$var->currency_id)->first();
    $allcurr=AllCurrency::all();
    return view('frontend.currency-pages',compact('symb','allcurr'));
   }

   public function deleteCurrency($id)
   {
    $cur=AllCurrency::where('id',$id)->first();
    $cur->delete();
    $var=Currency::get()->first();
    $symb=AllCurrency::where('id',$var->currency_id)->first();
    $allcurr=AllCurrency::all();
    return view('frontend.currency-pages',compact('symb','allcurr'));
   }


   public function LeadSource(Request $request)
   {
    $source=Source::where('company_id',Auth::user()->company_id)->orderby('id','desc')->get();
    return view('frontend.lead-source',compact('source'));
   }

   public function SaveSource(Request $request)
   {
    $comp_id=Auth::user()->company_id;
    $params['company_id']=$comp_id;
    $params['name']=$request->name;
    Source::create($params);
    return redirect('/leadsource');
   }

   public function EditSource($id,Request $request)
   {
    $comp_id=Auth::user()->company_id;
    Source::where('id',$id)->
    update([
        'name'=>$request->name,
    ]);
    return redirect('/leadsource');
   }

   public function DeleteSource($id)
   {
    $data=Source::find($id);
    $data->delete();
    return redirect('/leadsource');
   }

   public function SourceStatus(Request $request)
   {
    $id=$request->source_id;
    Source::find($id)
            ->update([
                'status'=>$request->status,
            ]);
    return response()->json(['success'=>'Status change successfully.']);
   }



    public function UserProfile()
    {
        $companies = Company::first();
        $logo = optional($companies)->logo;

        Session::put('logo', $logo);

        return view('frontend.users-profile', compact('companies'));
    }



   // public function Search(Request $request)
   // {
   //  $companyusers=User::where('company_id',Auth::user()->company_id)->get();
   //  $leads=Lead::where('phone',$request->searchquery)->get();
   //  if(count($leads)!=0){
   //   return view('frontend.searchpage',compact('leads','companyusers'));
   //  }
   //  else{
   //      $leads=0;
   //      return view('frontend.searchpage',compact('leads','companyusers'));
   //  }

   // }
}





