<?php $__env->startSection('main-container'); ?>
<main id="main" class="main">
<?php echo $__env->make('cdn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Products</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="<?php echo e(url('addproduct/create')); ?>">

            <button type="button" class="btns primary-btn  ml-4">

                <span class="btn-icon-left" style="color: white">+ Add Product</span>


            </button>

        </a>

    </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    <?php echo $__env->make('flash_msg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="<?php echo e(route('user_by_search_product.search')); ?>" method="get">
                        <div class="row">
                            <div class="form-group col-md-4">
                                <select class="form-control" name="group">
                                    <option value="">Select Group</option>
                                    <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($group->id); ?>" <?php echo e($group->id == $request->group ? 'selected' : ''); ?>><?php echo e($group->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                </select>
                            </div>
                           
                            <div class="form-group col-md-4">
                                <select class="form-control" name="category">
                                    <option value="">Select Category</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                         <option value="<?php echo e($cat->id); ?>" <?php echo e($cat->id == $request->category ? 'selected' : ''); ?>><?php echo e($cat->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                            </div>
                            <div class="col-md-2 form-group">
                                <input type="submit" class="btns primary-btn" value="Filter">
                            </div>
                        </div>
                    </form>

                    
                    <hr>

                    <hr>

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" >
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>IMAGE</th>

                                    <th>PRODUCT NAME</th>

                                    <th>PART NO</th>

                                    <th>GROUP NAME</th>

                                    <th>Category Name</th>

                                    <th>SALE PRICE</th>

                                    <th>STATUS</th>

                                    <th class="text-right">Action</th>

                                </tr>

                            </thead>

                            <tbody>

                                <?php if(!empty($add_products)): ?>

                                <?php $__currentLoopData = $add_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>

                                    <td><?php echo e(++$key); ?></td>

                                    <td>
                                        <?php if($value->image): ?>
                                        <img src="<?php echo e(url('/uploads/product/'.$value->image)); ?>" height="50" width="50">
                                        <?php else: ?>
                                        <img src="<?php echo e(url('/public/default.jpg')); ?>" height="50" width="50">
                                        <?php endif; ?>
                                    </td>

                                    <td><?php echo e($value->name); ?></td>

                                    <td><?php echo e($value->part_no); ?></td>

                                    <td><?php echo e($value->Group->name); ?></td>

                                    <td><?php echo e($value->Category->name); ?></td>

                                    <td>₹ <?php echo e($value->sale_price); ?> /-</td>

                                    <td>
                                        <?php if($value->status=='1'): ?>

                                            <a href="<?php echo e(url('productactive/'.$value->id)); ?>">

                                                <button class="btns success-btn">Active</button>

                                            </a>
                                            <?php else: ?>
                                            <a href="<?php echo e(url('productactive/'.$value->id)); ?>">

                                                <button class="btn btn-danger">InActive</button>

                                            </a>

                                            <?php endif; ?>
                                    </td>

                                    <td class="text-right">

                                        <a href="<?php echo e(route('products.edit',encrypt($value->id))); ?>">
                                        <button type="button" class="btns success-btn btn-sm" title="Edit" alt="Edit"><i class="fas fa-edit"></i> 
                                        </button>
                                         </a>


                                        <a href="<?php echo e(route('products.delete',encrypt($value->id))); ?>" onclick="return confirm('Are you sure?')">
                                        <button type="button" class="btns success-btn btn-sm" title="Delete" alt="Delete"><i class="fas fa-trash-alt"></i>
                                        </button>
                                        </a>


                                    </td>



                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php if($add_products->count() == 0): ?>

                                    <tr class="text-center">

                                        <td colspan="6">No Product to display.</td>

                                    </tr>

                                    <?php endif; ?>

                                <?php endif; ?>

                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Image</th>

                                    <th>Product Name</th>

                                    <th>Part No</th>

                                    <th>Group Name</th>

                                    <th>Category Name</th>
                                    
                                    <th>Sale Price</th>

                                    <th>Status</th>

                                    <th class="text-right">Action</th>

                                </tr>


                            </tfoot>

                        </table>

                    </div>

                     <div class="text-left float-left mt-1">

                       <p>Displaying <?php echo e($add_products->count()); ?> of <?php echo e($add_products->total()); ?> Add Products.</p>

                    </div>

                     <div class="pagination">
                        <ul class="pagination-list">
                            <?php if($add_products->currentPage() > 1): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($add_products->appends(request()->all())->previousPageUrl()); ?>" class="pagination-link">&lt;</a>
                                </li>
                            <?php endif; ?>

                            <?php if($add_products->currentPage() > 3): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($add_products->appends(request()->all())->url(1)); ?>" class="pagination-link">1</a>
                                </li>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                            <?php endif; ?>

                            <?php $__currentLoopData = range(max(1, $add_products->currentPage() - 2), min($add_products->lastPage(), $add_products->currentPage() + 2)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="pagination-item <?php echo e($page == $add_products->currentPage() ? 'active' : ''); ?>">
                                    <a href="<?php echo e($add_products->appends(request()->all())->url($page)); ?>" class="pagination-link"><?php echo e($page); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php if($add_products->currentPage() < $add_products->lastPage() - 2): ?>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                                <li class="pagination-item">
                                    <a href="<?php echo e($add_products->appends(request()->all())->url($add_products->lastPage())); ?>" class="pagination-link"><?php echo e($add_products->lastPage()); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if($add_products->hasMorePages()): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($add_products->appends(request()->all())->nextPageUrl()); ?>" class="pagination-link">&gt;</a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vinecork/public_html/webdev/Company/resources/views/product/index.blade.php ENDPATH**/ ?>