<?php $__env->startSection('main-container'); ?>
<main id="main" class="main">
<?php echo $__env->make('cdn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<div class="content-body">

    <div class="row page-titles mx-0">

            <div class="col-sm-6 p-md-0">

                <div class="breadcrumb-range-picker">

                    <h3 class="ml-1">Brands</h3>

                </div>

            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

                <a href="<?php echo e(url('brandmaster/create')); ?>">

                    <button type="button" class="btn btn-rounded bg-grad-4 ml-4">

                        <span class="btn-icon-left text-primary">

                            <i class="fa fa-plus color-primary"></i>

                        </span>
                       + Add Brand

                    </button>

                </a>

            </div>

        </div>

    <div class="container-fluid" style="margin-top: 15px">

        <?php echo $__env->make('flash_msg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <form method="GET" action="">

                            <div class="row text-right">

                                <div class="col-md-6"></div>

                                <div class="col-md-4">

                                    <input type="text" class="form-control right-search" name="search" value="<?php echo e($request->search); ?>" placeholder="Search by Brand Name">

                                </div>

                                <div class="col-md-2">

                                    <label class="">&nbsp;</label>

                                    <button type="submit" class="btn btn-outline-info bg-grad-4 btn-ft">Search</button>

                                </div>

                            </div>

                        </form>

                        <hr>

                        <div class="table-responsive">

                            <table class="table table-border table-hover table-sm" >

                                <thead>

                                    <tr>

                                        <th>#</th>

                                        <th>Image</th>

                                        <th>Brand Name</th>

                                        <th class="text-right">Action</th>

                                    </tr>

                                </thead>

                                 <tbody>

                                    <?php if(!empty($brand_masters)): ?>

                                    <?php $__currentLoopData = $brand_masters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>

                                        <td><?php echo e(++$key); ?></td>


                                        <td>

                                            <?php if($value->image): ?>
                                            <img src="<?php echo e(url('/uploads/brands/'.$value->image)); ?>" height="50" width="50">
                                            <?php endif; ?>

                                        </td>

                                        <td><?php echo e($value->name); ?></td>

                                        <td class="text-right">

                                            <a href="<?php echo e(route('brandmaster.edit',encrypt($value->id))); ?>"><button type="button" class="btn btn-outline-info btn-ft btn-sm" title="Edit" alt="Edit">Edit</button></a>

                                            <a href="<?php echo e(route('brandmaster.delete',encrypt($value->id))); ?>" onclick="return confirm('Are you sure?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Delete" alt="Delete">delete</button></a>

                                            </td>

                                        </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <?php if($brand_masters->count() == 0): ?>

                                        <tr class="text-center">

                                            <td colspan="6">No Brand Master to display.</td>

                                        </tr>

                                        <?php endif; ?>

                                    <?php endif; ?>

                                </tbody>

                                <tfoot>

                                    <tr>

                                        <th>#</th>

                                        <th>Image</th>

                                        <th>Brand Name</th>

                                        <th class="text-right">Action</th>

                                    </tr>

                                </tfoot>

                            </table>

                        </div>

                        <div class="text-left float-left mt-1">

                             <p>Displaying <?php echo e($brand_masters->count()); ?> of <?php echo e($brand_masters->total()); ?> Brands.</p>

                        </div>

                        <div class="pagination">
                            <ul class="pagination-list">
                                <?php if($brand_masters->currentPage() > 1): ?>
                                    <li class="pagination-item">
                                        <a href="<?php echo e($brand_masters->appends(request()->all())->previousPageUrl()); ?>" class="pagination-link">&lt;</a>
                                    </li>
                                <?php endif; ?>

                                <?php if($brand_masters->currentPage() > 3): ?>
                                    <li class="pagination-item">
                                        <a href="<?php echo e($brand_masters->appends(request()->all())->url(1)); ?>" class="pagination-link">1</a>
                                    </li>
                                    <li class="pagination-item disabled">
                                        <span class="pagination-link">...</span>
                                    </li>
                                <?php endif; ?>

                                <?php $__currentLoopData = range(max(1, $brand_masters->currentPage() - 2), min($brand_masters->lastPage(), $brand_masters->currentPage() + 2)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="pagination-item <?php echo e($page == $brand_masters->currentPage() ? 'active' : ''); ?>">
                                        <a href="<?php echo e($brand_masters->appends(request()->all())->url($page)); ?>" class="pagination-link"><?php echo e($page); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php if($brand_masters->currentPage() < $brand_masters->lastPage() - 2): ?>
                                    <li class="pagination-item disabled">
                                        <span class="pagination-link">...</span>
                                    </li>
                                    <li class="pagination-item">
                                        <a href="<?php echo e($brand_masters->appends(request()->all())->url($brand_masters->lastPage())); ?>" class="pagination-link"><?php echo e($brand_masters->lastPage()); ?></a>
                                    </li>
                                <?php endif; ?>

                                <?php if($brand_masters->hasMorePages()): ?>
                                    <li class="pagination-item">
                                        <a href="<?php echo e($brand_masters->appends(request()->all())->nextPageUrl()); ?>" class="pagination-link">&gt;</a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>



                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

</main><!-- End #main -->
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vinecork/public_html/webdev/DATA/resources/views/brandmaster/index.blade.php ENDPATH**/ ?>