<?php $__env->startSection('main-container'); ?>
  <main id="main" class="main">
    <div class="pagetitle">
        <div class="row page-titles mx-0">

          <div class="col-sm-6 p-md-0">

              <div class="breadcrumb-range-picker">

                   <h3>Employee</h3>

              </div>

          </div>

          <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

               <a href="<?php echo e(url('/showallusers')); ?>" class="btns primary-btn ml-4">

                  <span class="btn-icon-left" style="color: white">Back</span>

              </a>

          </div>

      </div>
      </div><!-- End Page Title -->
    <section class="section dashboard">
      <div class="row" style="margin-top: 25px">

        <!-- Left side columns -->
        <div class="col-lg-3">
            <!-- Sales Card -->
            <div class="card info-card sales-card">

                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="text-align-center">
                            <?php if($users->profile == null): ?>
                                <div class="rounded-circle border d-flex justify-content-center align-items-center"
                                    style="width: 60px; height: 60px; margin-top: 15px; margin-bottom: 10px;">
                                    <i class="bi bi-person-circle" style="font-size: 60px;"></i>
                                </div>
                            <?php else: ?>
                            <img src="<?php echo e(url('public/Image/' . $users->profile)); ?>" alt="avatar1"
                            class="rounded-circle" style="height: 60px; width: 60px; margin-top: 15px; margin-bottom: 10px;">
                            <?php endif; ?>
                            <p><?php echo e($users->name); ?></p>
                            <p><?php echo e($users->mobile); ?></p>
                            <span class="text-success small pt-1 fw-bold"></span>
                            <span class="text-muted small pt-2 ps-1"></span>
                        </div>
                    </div>
                </div>

            </div>
        </div><!-- End Sales Card --><!-- End Left side columns -->

        <div class="col-lg-9">
            <div class="card">
              <div class="card-body">
                <h5 class="card-title">About<span></span></h5>
                <table class="table">
                  <tbody>
                      <tr>
                        <td><strong>Email:</strong> <?php echo e($users->email); ?></td>
                          <td><strong>Status:</strong> <?php echo e($users->status == 1 ? 'Active' : 'Inactive'); ?></td>
                      </tr>
                      <tr>
                          <td><strong>Role:</strong> <?php echo e($users->role); ?></td>
                          <td><strong>D.O.B:</strong> <?php echo e(\Carbon\Carbon::parse($users->DOB)->format('d-m-Y')); ?></td>
                      </tr>
                      <tr>
                          <td><strong>State:</strong> <?php echo e($users->State->name); ?></td>
                          <td><strong>City:</strong> <?php echo e($users->City->name); ?></td>
                      </tr>

                  </tbody>
              </table>

              </div>
            </div>

          </div><!-- End Right side columns -->

      </div>

      <div class="tab">
        <button class="tablinks" onclick="openCity(event, 'London')">Attendence</button>
        <button class="tablinks" onclick="openCity(event, 'Paris')">Report</button>
        <button class="tablinks" onclick="openCity(event, 'Tokyo')">Order</button>
      </div>

      <div id="London" class="tabcontent">
        <h3>Attendence</h3>
        <table class="table">
            <thead>
              <td><strong>#</strong></td>
              <td><strong>Name</strong></td>
              <td><strong>Date</strong></td>
              <td><strong>Time_in</strong></td>
              <td><strong>Time_out</strong></td>
            </thead>

            <tbody>
                <?php $__currentLoopData = $attendences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e(++$key); ?></td>
                <td><?php echo e($value->User->name ?? 'No User'); ?></td>
                <td><?php echo e(\Carbon\Carbon::parse($value->date)->format('d-m-Y')); ?></td>
                 <td><?php echo e($value->time_in); ?></td>
                 <td><?php echo e($value->time_out); ?></td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

          </table>
      </div>

      <div id="Paris" class="tabcontent">
        <h3>Report</h3>
        <table class="table">
            <thead>
              <td><strong>#</strong></td>
              <td><strong>Name</strong></td>
              <td><strong>Date</strong></td>
              <td><strong>Work Report</strong></td>
            </thead>

            <tbody>
                <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e(++$key); ?></td>
                <td><?php echo e($value->User->name ?? 'No User'); ?></td>
                <td><?php echo e(\Carbon\Carbon::parse($value->date)->format('d-m-Y')); ?></td>
                 <td><?php echo e($value->message); ?></td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

          </table>
      </div>

      <div id="Tokyo" class="tabcontent">
        <h3>Order</h3>
        <table class="table">
            <thead>
              <td><strong>#</strong></td>
              <td><strong>Name</strong></td>
              <td><strong>Customer Name</strong></td>
              <td><strong>Date</strong></td>
              <td><strong>Amount</strong></td>
            </thead>

            <tbody>
                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e(++$key); ?></td>
                <td><?php echo e($value->User->name ?? 'No User'); ?></td>
                 <td><?php echo e($value->Customer->name ?? 'No Customer'); ?></td>
                 <td><?php echo e(\Carbon\Carbon::parse($value->created_at)->format('d-m-Y')); ?></td>
                 <td>₹ <?php echo e($value->amount); ?> /-</td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

          </table>
      </div>

      <script>
        function openCity(evt, cityName) {
          var i, tabcontent, tablinks;
          tabcontent = document.getElementsByClassName("tabcontent");
          for (i = 0; i < tabcontent.length; i++) {
            tabcontent[i].style.display = "none";
          }
          tablinks = document.getElementsByClassName("tablinks");
          for (i = 0; i < tablinks.length; i++) {
            tablinks[i].className = tablinks[i].className.replace(" active", "");
          }
          document.getElementById(cityName).style.display = "block";
          evt.currentTarget.className += " active";
        }
    </script>

      <!-- End 3 section -->

    </section>

  </main><!-- End #main -->

 <?php $__env->stopSection(); ?>





<?php echo $__env->make('frontend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vinecork/public_html/webdev/DATA/resources/views/frontend/employee-view.blade.php ENDPATH**/ ?>