@extends('frontend.layouts.main')

@section('main-container')
  <main id="main" class="main">
    @include('cdn')
    <div class="">
      <div class="row page-titles mx-0">

        <div class="col-sm-6 p-md-0">

            <div class="breadcrumb-range-picker">

                 <h4>User Info</h4>

            </div>

        </div>

        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

            <a href="{{route('users')}}">

                <button type="button" class="btns success-btn btn-sm">

                    <i class="fas fa-arrow-left"></i> Back

                </button>

            </a>

        </div>

    </div>
    </div><!-- End Page Title -->
    <section class="section dashboard">
      <div class="row" style="margin-top: 25px">

        <!-- Left side columns -->
        <div class="col-lg-3">
            <!-- Sales Card -->
            <div class="card info-card sales-card">

                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="text-align-center">
                            @if ($user->profile == null)
                                <div class="rounded-circle border d-flex justify-content-center align-items-center"
                                    style="width: 60px; height: 60px; margin-top: 15px; margin-bottom: 10px;">
                                    <i class="bi bi-person-circle" style="font-size: 60px;"></i>
                                </div>
                            @else
                            <img src="{{ url('public/Image/' . $user->profile) }}" alt="avatar1"
                            class="rounded-circle" style="height: 60px; width: 60px; margin-top: 15px; margin-bottom: 10px;">
                            @endif
                            <p>{{ $user->name }}</p>
                            <p>{{ $user->mobile }}</p>
                            <span class="text-success small pt-1 fw-bold"></span>
                            <span class="text-muted small pt-2 ps-1"></span>
                        </div>
                    </div>
                </div>

            </div>
        </div><!-- End Sales Card -->

        <!-- End Left side columns -->

        <div class="col-lg-9">
            <div class="card">
              <div class="card-body">
                <h5 class="card-title">About<span></span></h5>
                <table class="table">
                  <tbody>
                      <tr>
                          <td><strong>Email:</strong> {{ $user->email }}</td>
                          <td><strong>Role:</strong> {{ $user->role }}</td>
                      </tr>
                      <tr>
                          <td><strong>D.O.B:</strong> {{ \Carbon\Carbon::parse($user->DOB)->format('d-m-Y') }}</td>
                          <td><strong>Status:</strong> {{ $user->status == 1 ? 'Active' : 'Inactive' }}</td>
                      </tr>
                      
                      <tr>
                          <td><strong>State:</strong> {{ $user->State->name ?? 'N/A'  }}</td>
                          <td><strong>City:</strong> {{ $user->City->name ?? 'N/A'  }}</td>
                      </tr>
                      <tr>
                          <td><strong>PinCode:</strong> {{ $user->pincode }}</td>
                          <td><strong>Bank Details:</strong> {!! str_replace('<br />', ' ', strip_tags($user->bank_details)) !!}</td>

                      </tr>
        
                  </tbody>
              </table>


              </div>
            </div>

          </div><!-- End Right side columns -->


      </div>


    </section>

  </main><!-- End #main -->

 @endsection


