@extends('frontend.layouts.main')

@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h4>Report</h4>

        </div>

    </div>

    <div class="row">
    <form action="{{ route('report.search') }}" method="get">
    <div class="col-md-12">
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <select class="form-control dropdown-toggle" name="user_id">
                        <option value="">Select User</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ $user->id == $request->user_id ? 'selected' : '' }}>{{ $user->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <select class="form-control dropdown-toggle" name="location">
                        <option value="">Select Location</option>
                        @foreach($locations as $loc)
                            <option value="{{ $loc->id }}" {{ $loc->id == $request->location ? 'selected' : '' }}>{{ $loc->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-4">
            </div>
        </div>
    </div>
     <div class="col-md-12">
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="date_from">Date From</label>
                    <input type="date" name="date_from" class="form-control" value="{{ $request->date_from }}">
                </div>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                    <label for="date_to">Date To</label>
                    <input type="date" name="date_to" class="form-control" value="{{ $request->date_to }}">
                </div>
            </div>

            <div class="col-md-1 form-group" style="margin-top:30px;">
                <input type="submit" class="btn btn-primary" value="Search">
            </div>

            <div class="col-md-1 form-group" style="margin-top:30px;">
                <a href="{{route('reports')}}" class="btn btn-primary text-white">Refresh</a>
            </div>

        </div>
    </div>
</form>

</div>

<div class="container-fluid">

    @include('flash_msg')


    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" id="tabl">
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Party Name</th>

                                    <th>Location</th>

                                    <th>Date</th>

                                    <th>Action</th>

                                </tr>

                            </thead>

                            <tbody>

                                @if(!empty($datas))

                                    @foreach($datas as $key => $value)

                                        <tr>
                                            
                                            <td>{{ ++$key }}</td>

                                            <td>{{ $value->User->name ?? 'N/A' }}</td>

                                            <td>{{ $value->party_name }}</td>

                                            <td>{{ $value->Location->name ?? 'N/A' }}</td>

                                            <td>{{ $value->created_at->format('Y-m-d') }}</td>

                                            <td>
                                                 <a role="button" data-toggle="modal" data-target="#viewComplain-{{ $value->id }}">
                                                <button type="button" class="btns success-btn btn-sm" title="More Details" alt="More Details"><i class="fas fa-eye"></i> 
                                                </button>
                                                </a>
                                            </td>


                                               <!-- Modal view remark-->

                                                    <div class="modal fade" id="viewComplain-{{$value->id}}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">

                                                    <div class="modal-dialog" role="document">

                                                    <div class="modal-content">

                                                      <div class="modal-header btns primary-btn">

                                                        <h5 class="modal-title" id="editModalLabel">Report</h5>

                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                                                          <span aria-hidden="true" style="color: white !important;">&times;</span>

                                                        </button>

                                                      </div>

                                                      <div class="modal-body">

                                                        <div class="row">

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Name:</strong>&nbsp {{ $value->User->name ?? 'N/A' }}</label>

                                                            </div>

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Location:</strong>&nbsp {{ $value->Location->name ?? 'N/A' }}</label>

                                                            </div>

                                                        </div>

                                                        <div class="row">

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Date:</strong>&nbsp {{ $value->created_at->format('Y-m-d') }}</label>

                                                            </div>

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Party Name:</strong>&nbsp {{ $value->party_name }}</label>

                                                            </div>

                                                        </div>

                                                        <div class="row">

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Mobile:</strong>&nbsp {{ $value->mobile_no }}</label>

                                                            </div>

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Address:</strong>&nbsp {{ $value->address }}</label>

                                                            </div>

                                                        </div>

                                                        <div class="row">

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Item Name:</strong>&nbsp {{ $value-> item_name}}</label>

                                                            </div>

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Vahicle No:</strong>&nbsp {{ $value->vahicle_no }}</label>

                                                            </div>

                                                        </div>

                                                        <div class="row">

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Gross Weight</strong>&nbsp {{ $value->gross_weight}}</label>

                                                            </div>

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Tare Weight:</strong>&nbsp {{ $value->tare_weight }}</label>

                                                            </div>

                                                        </div>

                                                        <div class="row">

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Net Weight:</strong>&nbsp {{ $value-> net_weight}}</label>

                                                            </div>

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Bag:</strong>&nbsp {{ $value->bag }}</label>

                                                            </div>

                                                        </div>

                                                        <div class="row">

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Moishcher:</strong>&nbsp {{ $value-> moishcher}}</label>

                                                            </div>

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Remarks:</strong>&nbsp {{ $value->remarks }}</label>

                                                            </div>

                                                        </div>

                                                        <div class="row">

                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Kata Slip Image:</strong></label>
                                                                  <br>

                                                                   @if($value->kata_slip_image)
                                                                        <img src="{{ asset('public/Report/' . $value->kata_slip_image) }}" height="80" width="80" alt="Image">
                                                                    @else
                                                                        <p>Image Not Found</p>
                                                                    @endif


                                                            </div>


                                                            <div class="col-lg-6 mb-2">

                                                                  <label for="exampleFormControlTextarea1"><strong>Photo Click Lori Image:</strong></label>

                                                                  <br>

                                                                  @if($value->photo_click_lori_image)
                                                                        <img src="{{ asset('public/Report/' . $value->photo_click_lori_image) }}" height="80" width="80" alt="Image">
                                                                  @else
                                                                      <p>Image Not Found</p>
                                                                  @endif


                                                            </div>

                                                        </div>

                                                    </div>

                                                 </div>

                                            </div>

                                        </div>


                                        </tr>

                                    @endforeach

                                @endif
                                
                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Name</th>

                                     <th>Party Name</th>

                                    <th>Location</th>

                                    <th>Date</th>

                                    <th>Action</th>
                                </tr>


                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->

<script type="text/javascript">
     $(document).ready(function () {
      $('#tabl').DataTable({
         
      });
  });
  </script>

@endsection



