@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Employee</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

         <a href="{{url('/addnewuser')}}" class="btns primary-btn ml-4">

            <span class="btn-icon-left" style="color: white">+ Add Employee</span>

        </a>

    </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form method="GET" action="">

                        <div class="row text-right">

                            <div class="col-md-6"></div>

                            <div class="col-md-4">

                                 <input type="text" class="form-control right-search" name="search" value="{{$request->search}}" placeholder="Search by User">

                            </div>

                             <div class="col-md-2">

                                <label class="">&nbsp;</label>

                                <button type="submit" class="btns primary-btn btn-ft">Search</button>

                            </div>

                        </div>

                    </form>

                    <hr>

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" >
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>NAME</th>

                                    <th>EMAIL</th>

                                    <th>MOBILE</th>

                                    <th>D.O.B</th>

                                    <th>Status</th>

                                    <th>ACTION</th>

                                </tr>

                            </thead>

                            <tbody>
                                @if(!empty($users))
                                @foreach($users as $key=>$value)
                                 <tr>
                                   <td></td>
                                   <td>{{$value->name}}</td>
                                   <td>{{$value->email}}</td>
                                   <td>{{$value->mobile}}</td>
                                   <td>{{ \Carbon\Carbon::parse($value->DOB)->format('d-m-Y') }}</td>

                                   <td>
                                    @if($value->status=='1')

                                        <a href="{{url('employeeactive/'.$value->id)}}">

                                            <button class="btns success-btn">Active</button>

                                        </a>
                                        @else
                                        <a href="{{url('employeeactive/'.$value->id)}}">

                                            <button class="btn btn-danger">DeActive</button>

                                        </a>

                                        @endif
                                </td>

                                <td class="text-right">


                                     <a href="{{ route('employee.view',encrypt($value->id)) }}">
                                            <button type="button" class="btns success-btn btn-sm" title="View More" alt="View More">
                                                <i class="fas fa-eye"></i> 
                                            </button>
                                        </a>


                                         <a href="{{ route('employee.edit', encrypt($value->id)) }}">
                                        <button type="button" class="btns success-btn btn-sm" title="Edit" alt="Edit"><i class="fas fa-edit"></i> 
                                        </button>
                                         </a>

                                        <a href="{{ route('employee.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure?')">
                                        <button type="button" class="btns success-btn btn-sm" title="Delete" alt="Delete"><i class="fas fa-trash-alt"></i>
                                        </button>
                                        </a>

                                </td>

                                 </tr>
                               @endforeach

                               @if ($users->count() == 0)

                                        <tr class="text-center">

                                            <td colspan="6">No Employee to display.</td>

                                        </tr>

                                @endif
                                @endif
                               </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Email</th>

                                    <th>Mobile</th>

                                    <th>D.O.B</th>

                                    <th>Status</th>

                                    <th>Action</th>



                                </tr>


                            </tfoot>

                        </table>

                    </div>

                      <div class="text-left float-left mt-1">

                       <p>Displaying {{$users->count()}} of {{ $users->total() }} Add Users.</p>

                    </div>

                    <div class="pagination">
                        <ul class="pagination-list">
                            @if ($users->currentPage() > 1)
                                <li class="pagination-item">
                                    <a href="{{ $users->appends(request()->all())->previousPageUrl() }}" class="pagination-link">&lt;</a>
                                </li>
                            @endif

                            @if ($users->currentPage() > 3)
                                <li class="pagination-item">
                                    <a href="{{ $users->appends(request()->all())->url(1) }}" class="pagination-link">1</a>
                                </li>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                            @endif

                            @foreach(range(max(1, $users->currentPage() - 2), min($users->lastPage(), $users->currentPage() + 2)) as $page)
                                <li class="pagination-item {{ $page == $users->currentPage() ? 'active' : '' }}">
                                    <a href="{{ $users->appends(request()->all())->url($page) }}" class="pagination-link">{{ $page }}</a>
                                </li>
                            @endforeach

                            @if ($users->currentPage() < $users->lastPage() - 2)
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                                <li class="pagination-item">
                                    <a href="{{ $users->appends(request()->all())->url($users->lastPage()) }}" class="pagination-link">{{ $users->lastPage() }}</a>
                                </li>
                            @endif

                            @if ($users->hasMorePages())
                                <li class="pagination-item">
                                    <a href="{{ $users->appends(request()->all())->nextPageUrl() }}" class="pagination-link">&gt;</a>
                                </li>
                            @endif
                        </ul>
                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
<script type="text/javascript">
   $(document).ready(function () {
    var table = $('#tabl').DataTable({
      order: [],
      columnDefs: [ { orderable: false, targets: [0,1,2,3,4,5,6] } ],
      responsive: true
    });

    new $.fn.dataTable.FixedHeader( table );
});
</script>
<script type="text/javascript">
       $("document").ready(function(){
        setTimeout(function()
        {
            $("div.alert").remove();

        }, 3000);

       });

</script>
@endsection
