@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Roles</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <button type="button" class="btns primary-btn ml-4" data-toggle="modal" data-target="#addRole-{{$permissions}}" style="color: white">+Add Role</button>
    </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">
                    
                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" id="tabl">
                            <thead>
                                <tr>
                                    <th>S.No</th>
                                    <th>Role</th>
                                    <th>Action</th>
                                </tr>
                            </thead>

                            <tbody>
                                @if(!empty($roles))
                                @foreach($roles as $key=>$value)
                         <tr>
                        <td>{{ ++$key }}</td>
                        <td style="text-transform:capitalize;">{{$value->name}}</td>
                        <td>

                           <a href="{{url('permissions/'.$value->id)}}" ><button type="button" class="btns success-btn">Permission</button></a>
                          @can('roles.edit')
                          <a class="btns success-btn" role="button" data-toggle="modal" data-target="#editRole-{{ $value->id }}"><span style="color:white;">Edit</span></a>
                          @endcan
                            <!-- Modal -->
                            <div class="modal fade" id="editRole-{{$value->id}}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header bg-info bg-gradient">
                                <h5 class="modal-title" id="editModalLabel">Edit Role</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>

                               <form action="{{url('role-edit/'.$value->id)}}" method="post">
                                {{ csrf_field() }}

                              <div class="modal-body">
                                <div class="row mb-3">
                                          <label for="inputText" class="col-sm-4 col-form-label">Role</label>
                                          <div class="col-sm-7">
                                            <input type="text" name="name" value="{{$value->name}}" class="form-control" style="text-transform: capitalize;" required>
                                          </div>
                                </div>
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btns primary-btn" data-dismiss="modal">Close</button>
                                <button type="submit" class="btns primary-btn">Edit</button>
                              </div>
                            </form>
                            </div>
                            </div>
                            </div>
                            @can('roles.delete')

                          <a href="{{url('deleterole/'.$value->id)}}" onclick="return confirm('Are you sure?')">
                                <button type="button" class="btns success-btn btn-sm" title="Delete" alt="Delete"><i class="fas fa-trash-alt"></i>
                                </button>
                          </a>
                          @endcan
                        </td>

                    </tr>
                   @endforeach
                  
                                @endif

                               </tbody>

                            <tfoot>

                                <tr>
                                    <th>S.No</th>
                                    <th>Role</th>
                                    <th>Action</th>
                                </tr>


                            </tfoot>

                        </table>

                    </div>


                </div>

            </div>

        </div>

    </div>

</div>

<!-- Modal -->
<div class="modal fade" id="addRole-{{$permissions}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header  btns primary-btn" >
          <h5 class="modal-title" id="exampleModalLabel">Add Role</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
         <form action="{{url('/role-submit')}}" method="post">
          {{ csrf_field() }}

        <div class="modal-body" style="height:380px; overflow-y: scroll;">
          <div class="row mb-3">
                    <label for="inputText" class="col-sm-4 col-form-label">Role<span style="color:red;">*</span></label>
                    <div class="col-sm-7">
                      <input type="text" name="r_name" class="form-control" placeholder="Enter Role" required>
                    </div>
          </div>
            <h5>Permissions</h5>
                   @foreach($permissions as $permission)
                       <div class="form-check form-check-inline">
                          <input class="form-check-input p-2" type="checkbox" name="permission[]" id="inlineCheckbox1" value="{{$permission->id}}">
                        <label class="form-check-label p-2" for="inlineCheckbox1" style="text-transform:capitalize;">{{$permission->name}}</label>
                       </div>
                      @endforeach
        </div>
        <div class="modal-footer ">
          <button type="button" class="btns primary-btn" data-dismiss="modal">Close</button>
          <button type="submit" class="btns primary-btn">Add</button>
        </div>
      </form>
      </div>
    </div>
  </div>
  </main>
  <script type="text/javascript">
     $(document).ready(function () {
      $('#tabl').DataTable({
         
      });
  });
  </script>
  <script type="text/javascript">

     $(document).on('click','.open_modal',function(){
          var url = "domain.com/yoururl";
          var role_id= $(this).val();
          $.get(url + '/' + role_id, function (data) {
              //success data
              console.log(data);
              $('#role_id').val(data.id);
              $('#name').val(data.name);
             $('#btn-save').val("update");

          })
      });
  </script>

  @endsection
