@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')
<div class="content-wrapper">
        <div class="row ">
          <div class="card">
            <div class="card-body">

              <div class="row">
                <div class="col-md-6">
                  <div class="form-group row ">
                    <h4 class="card-title">LEAD INFORMATION</h4>
                  </div>
                </div>
              </div>
              <form action="{{ url('/savenewlead')}}" method="POST" class="form-sample">
               {{ csrf_field() }}
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Name<span style="color:red;">*</span></label>
                      <div class="col-sm-8">
                          <input type="text" name="name" class="form-control" placeholder="Enter Name" required/>
                          @error('name')
                          <div class="alert alert-danger mt-1 mb-1">{{ $message }}</div>
                          @enderror
                      </div>
                    </div>
                  </div>
                   <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Lead Source</label>
                      <div class="col-sm-7">
                        <select class="custom-select" name="l_source">
                          <option value="">Select Lead Source</option>
                          @foreach($source as $sour)
                            <option value="{{$sour->id}}">{{$sour->name}}</option>
                          @endforeach
                        </select>
                      </div>
                    </div>
                  </div>   
                </div>

                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Investment ($)</label>
                      <div class="col-sm-8">
                        <input class="form-control" type="number" name="invest">
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Trading Experience</label>
                      <div class="col-sm-7">
                        <input class="form-control" type="text" name="expense">
                      </div>
                    </div>
                  </div>
                   
                </div>
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Trading Segment</label>
                      <div class="col-sm-8">
                        <input class="form-control" type="text" name="trade">
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Assign To</label>
                      <div class="col-sm-7">
                        <select class="custom-select" name="assigned">
                          <option value="0">Select User</option>
                          @foreach($users as $user)
                          @if($user->id==Auth::user()->id)

                          @else
                            <option value="{{$user->id}}">{{$user->name}}</option>
                          @endif  
                          @endforeach
                        </select>
                      </div>
                    </div>
                  </div>

                  
                </div>

                <h4 class="card-title">CONTACT INFORMATION</h4>
               

                <div class="row">
                  <div class="col-md-6">
                        <div class="form-group row">
                          <label class="col-sm-4 col-form-label">Country<span style="color:red;">*</span></label>
                          <div class="col-sm-8">
                            <select class="custom-select" name="country" required>
                                <option value="">Select Country</option>
                                @foreach($countries as $country)
                                <option value="{{$country->id}}">{{$country->name}}</option>
                                @endforeach
                              </select>
                              @error('Country')
                              <div class="alert alert-danger mt-1 mb-1">{{ $message }}</div>
                              @enderror
                          </div>
                        </div>
                   </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Contact Number<span style="color:red;">*</span></label>
                      <div class="col-sm-8">
                        
                          <input type="text" name="phone" maxlength="15" class="form-control" placeholder="Enter Phone Number" required/>
                        
                        @error('phone')
                          <div class="alert alert-danger mt-1 mb-1">{{ $message }}</div>
                        @enderror
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Additional Number</label>
                      <div class="col-sm-8">
                        <input type="text" name="mobile" maxlength="15" class="form-control" placeholder="Enter Your Mobile Number">
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Email</label>
                      <div class="col-sm-8">
                        <input type="email" name="email" class="form-control" placeholder="Enter Your Email">
                      </div>
                    </div>
                  </div>
                </div>    
              
                <h4 class="card-title">ADDITIONAL INFORMATION</h4>
              
                <div class="row">
                  <div class="col-md-8">
                    <div class="form-group row">
                      <label class="col-sm-3 col-form-label">Description<span style="color:red;">*</span></label>
                      <div class="col-sm-9">
                        <textarea type="text" name="notes" class="form-control" placeholder="Write Something" required></textarea>
                         @error('Country')
                              <div class="alert alert-danger mt-1 mb-1">{{ $message }}</div>
                          @enderror
                      </div>
                    </div>
                  </div>
                    <br>
                    <br>
                </div>
                <button type="submit"  class="btn btn-primary" style="margin-right:7px;">Submit</button>
                <a href="{{url('/showlead')}}"><button type="button" class="btn btn-primary">Cancel</button></a> 

              </form>
              <div class="col-md-12">
                  <div class="form-group row" style="float: right;">
                    <a href="{{url('/showlead')}}" class="auth-link text-black">Back..
                    </a>
                  </div>
              </div>
            </div>
          </div>
        </div>
      </div>
</main><!-- End #main -->
<script type="text/javascript">
       $("document").ready(function(){
        setTimeout(function()
        {
            $("div.alert").remove();

        }, 3000);

       });

</script>

<!-- <script>
$(document).ready(function() {
$('#country-dropdown').on('change', function() {
var country_id = this.value;
$.ajax({
url: 'get-countrycode-by-country',
method: 'POST',
data: {
country_id: country_id,
_token: '{{csrf_token()}}' 
},
dataType : 'json',
success: function(response){
   $('#phone-field').val(response[0].phonecode);
}
});
});    
});
</script> -->

@endsection