@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Edit Employee</h3>

        </div>

    </div>

     <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

         <a href="{{route('showallusers')}}" class="btns primary-btn ml-4">

            <span class="btn-icon-left" style="color: white">Back</span>

        </a>

    </div>

</div>



<div class="content-wrapper" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="{{route('employee.update',$users->id)}}" method="POST" class="form-sample" enctype="multipart/form-data">
                            {{ csrf_field() }}

                        <!-- Modal body -->
                        <div class="row">

                                <div class="form-group col-lg-6">
                                  <label>Name<span class="text-danger">*</span></label>
                                  <input type="text" class="form-control" name="name" value="{{$users->name}}" placeholder="Name">
                                  <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
                                </div>

                                 <div class="form-group col-lg-6">
                                    <label>Mobile<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="mobile" value="{{$users->mobile}}" placeholder="Enter Mobile No">
                                    <span class="text-danger"> @error('mobile'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Email<span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" name="email" value="{{$users->email}}" placeholder="Enter Email Id">
                                    <span class="text-danger"> @error('email'){{ $message }}@enderror </span>
                                </div>


                                <div class="form-group col-lg-6">
                                    <label>Role <span class="text-danger">*</span></label>
                                     <select class=" form-control dropdown-toggle" name="role" type="button" data-toggle="dropdown">
                                        <option value="">Select Role</option>
                                        @foreach($role as $rol)
                                        <option value="{{$rol->name}}" {{$rol->name==$users->role?'selected':''}}>{{$rol->name}}</option>
                                          @endforeach
                                      </select>
                                    <span class="text-danger">@error('role'){{ $message }}@enderror</span>
                                </div>


                                <div class="form-group col-lg-6">
                                    <label>DOB<span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" name="dob" value="{{$users->DOB}}" placeholder="Enter date of birth">
                                    <span class="text-danger"> @error('dob'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label for="state">State<span class="text-danger">*</span></label>
                                    <select class="form-control" id="state-dropdown" name="state">
                                        <option value="">Select State</option>
                                        @foreach ($states as $state)
                                        <option value="{{$state->id}}" {{$state->id==$users->state?'selected':''}}>{{$state->name}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label for="city">City<span class="text-danger">*</span></label>
                                    <select class="form-control" id="city-dropdown" name="city">
                                        <option value="">Select City</option>
                                        @foreach ($cities as $city)
                                        <option value="{{$city->id}}" {{$city->id==$users->city?'selected':''}}>{{$city->name}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="text-center">
                                    <button type="submit"  class="btns primary-btn" style="margin-right:7px;">Submit</button>
                                </div>
                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>

<script type="text/javascript">
    $("document").ready(function(){
     setTimeout(function()
     {
         $("div.alert").remove();

     }, 3000);

    });

</script>

<script>
    $(document).ready(function() {
        $('#state-dropdown').on('change', function() {
            var state_id = this.value;
            $("#city-dropdown").html('');
            $.ajax({
                url:"{{url('get-cities-by-state')}}",
                type: "POST",
                data: {
                    state_id: state_id,
                    _token: '{{csrf_token()}}'
                },
                dataType : 'json',
                success: function(result) {
                    $.each(result.cities, function(key, value) {
                        $("#city-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
                    });
                }
            });
        });
    });
</script>
 @endsection

 <script>
    $(document).ready(function() {
        $('#state-dropdown').on('change', function() {
            var state_id = this.value;
            $("#city-dropdown").html('');
            $.ajax({
                url:"{{url('get-cities-by-state')}}",
                type: "POST",
                data: {
                    state_id: state_id,
                    _token: '{{csrf_token()}}'
                },
                dataType : 'json',
                success: function(result) {
                    $.each(result.cities, function(key, value) {
                        $("#city-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
                    });
                }
            });
        });
    });
</script>




