@extends('frontend.layouts.main')
@section('main-container')

<main id="main" class="main">
    @include('cdn')
     <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
     <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
     <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js" integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous"></script>
     <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js" integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous"></script>
     <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
    <div class="container mt-2" style="margin-top: 100px; height: 550px;">
        
        <h3 class="card-title">Customers</h3>
         @if ($message = Session::get('success'))
         <div class="alert alert-success" id="alert">
            <button type="button" class="close" data-dismiss="alert">x</button>
         <p>{{ $message }}</p>
        </div>
         @endif
         <div class="btn-lg float-right">
          <a href="{{url('/components-regis')}}"><button type="submit" class="btn btn-info">Add Company</button> </a>
          </div>
        <table class="table table-striped display nowrap " id="tabl">
            <thead>
                <tr>
                    <th>S.No</th>
                    <th>Name</th>
                    <th>Company</th>
                    <th>Email</th>
                    <th>Address</th>
                    <th>Mobile</th>
                    <!-- <th>country</th>
                    <th>state</th>
                    <th>city</th> -->
                    <th>Action</th>  
                </tr>
            </thead>
            <tbody>
                @foreach ($companies as $company)
                    <tr>
                        <td>{{ $company->id }}</td>
                        <td>{{ $company->name}}</td>
                        <td>{{ $company->c_name}}</td>
                        <td>{{ $company->email}}</td>
                        <td>{{ $company->address}}</td>
                        <td>{{ $company->mobile}}</td>
                        <!-- <td>{{ $company->country_info->name}}</td>
                        <td>{{ $company->state_info->name}}</td>
                        <td>{{ $company->city_info->name}}</td>   -->
                        <td><a href="{{url('company-edit',$company->id)}}"><button type="submit" class="btn btn-info">Edit</button> </a>
                             <a href="{{url('company-delete',$company->id)}}"><button type="submit" class="btn btn-info">Delete</button> </a>
                             <a href="{{url('company-more',$company->id)}}"><button type="submit" class="btn btn-info">More</button> </a>
                              
                        </td>       
                    </tr>
                @endforeach
            </tbody>
         </table>   
    </div>



<script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.3.2/js/dataTables.buttons.min.js
"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js
"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.3.2/js/buttons.html5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.3.2/js/buttons.print.min.js"></script>


 <script type="text/javascript">  
    $(document).ready(function() {
    $('#tabl').DataTable( {
        dom: 'Bfrtip',
        ordering:false,
        buttons: [
             'csv', 'excel', 'pdf', 'print'
        ]
        
    } );
} );
    
</script>
<script type="text/javascript">
       $("document").ready(function(){
        setTimeout(function()
        {
            $("div.alert").remove();

        }, 3000);

       });

</script>
</main>
@endsection