@extends('backend.company.layouts.main')
@section('main-container')
<main id="main" class="main">
    @include('cdn')

    <div class="row page-titles mx-0">

        <div class="col-sm-6 p-md-0">

            <div class="breadcrumb-range-picker">

                 <h4>Roles</h4>

            </div>

        </div>
        @can('role.create')
        <div class="col-sm-6 p-md-0 justify-content-sm-end mb-2 mt-sm-0 d-flex">
            
            <a href="{{ route('seller.role.create') }}">

                <button type="button" class="btns success-btn btn-sm">

                    <i class="fas fa-plus"></i> Add Role

                </button>

            </a>
            
        </div>
        @endcan

    </div>

    <div class="container-fluid">

        @include('flash_msg')

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <div class="table-responsive">

                            <table class="table table-border table-hover table-sm" id="tabl">
                                
                                <thead>
                                    
                                    <tr>
                                        <th>S.No</th>
                                        <th>Role</th>
                                        <th>Action</th>
                                    </tr>
                                
                                </thead>

                                <tbody>
                                    @if(!empty($roles))
                                        @foreach($roles as $key=>$value)
                                            <tr>
                                                <td>{{ ++$key }}</td>
                                                <td>{{str_replace('_','',str_replace(Auth::user()->company_id,'',$value->name))}}</td>
                                                <td>
                                                    @can('role.permission')
                                                    <a href="{{route('seller.role.permissions',$value->id)}}" class="color-green" title="Assign Permission" alt="Assign Permission">

                                                        <i class="fas fa-gear"></i>

                                                    </a>
                                                    |
                                                    @endcan

                                                    @can('role.edit')
                                                    <a href="{{route('seller.role.permissions',$value->id)}}" class="color-green" title="Edit" alt="Edit">
                                                    
                                                        <i class="fas fa-edit"></i> 
                                                        
                                                    </a>
                                                    |
                                                    @endcan

                                                    @can('role.delete')
                                                    <a href="{{url('deleterole/'.$value->id)}}" onclick="return confirm('Are you sure delete this?')" title="Delete" alt="Delete" class="color-green">
                                                        
                                                        <i class="fas fa-trash-alt"></i>
                                                        
                                                    </a>
                                                    |
                                                    @endcan

                                                </td>

                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                                
                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</main>

@endsection
