<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{Attendence, User,Group,GroupUsers,State,City,Order, Report};
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Facades\Crypt;

class UserController extends Controller
{

   public function edit($id)
    {

        $id=decrypt($id);
        $users = User::find($id);
        $role=Role::all();
        $groups=Group::all();
        $states = State::get(["name","id"]);
        $cities = City::get(["name","id"]);
        return view('frontend.employee-edit',compact('users','role','groups','states','cities'));
    }


    public function update($id,Request $request){
    $user=User::find($id);
    $user->assignRole($request->role);
    User::where('id',$id)->
    update([
        'name'=>$request->name,
        'role'=>$request->role,
        'email'=>$request->email,
        'mobile'=>$request->mobile,
        'DOB'=>$request->dob,
    ]);
    return redirect()->route('showallusers');
   }

   public function View($id)
    {

        $id=decrypt($id);

        $users = User::find($id);
        if (!$users) {
            // Handle the case where the user doesn't exist
            return redirect()->route('error.page')->with('message', 'User not found');
        }

        $orders = Order::where('user_id', $id)->get();
        $reports = Report::where('user_id', $id)->get();
        $attendences = Attendence::where('user_id', $id)->get();

        $role=Role::all();
        $states = State::get(["name","id"]);
        $cities = City::get(["name","id"]);

        return view('frontend.employee-view',compact('users','role','states','cities','orders','reports','attendences'));
    }


   public function delete($id)
    {
        $id=decrypt($id);

        $users=User::find($id);

        $users->delete();

        return redirect('showallusers')->with('error','Employee deleted successfully.');
    }

   public function NewGroup()
   {
    $groups=Group::orderby('id','desc')->get();
    $users=User::all();
    return view('frontend.newgroup',compact('groups','users'));
   }

   public function SaveGroup(Request $request)
   {

    $params['name']=$request->name;
    $params['group_manager']=$request->group_manager;
    $group=Group::create($params);
    if($group){
        User::where('id',$request->group_manager)
        ->update([
            'group_id'=>$group->id,
        ]);
    }
    return redirect()->route('newgroup')->with('success','Group Create Successfully');
   }

    public function EditGroup($id,Request $request)
    {
    Group::where('id',$id)->
    update([
        'name'=>$request->name,
        'group_manager'=>$request->group_manager,
    ]);

    User::where('id',$request->group_manager)
        ->update([
            'group_id'=>$id,
        ]);
    return redirect()->route('newgroup')->with('success','Group Edit Successfully');
   }

    public function GroupStatus($group_id){
    $id=$group_id;
    $data = Group::find($id);
    if($data->status=='1'){
        $status = '0';
    } else {
        $status = '1';
    }
    $data->update([
                'status'=>$status,
            ]);
    return redirect()->route('newgroup')->with('success','Group Status Update Successfully');
   }

   public function Group_users($id)
   {
    $group=Group::find($id);
    Session::put('group',$group);
    return redirect('/memberofgroup');
   }

   public function AddGroupUser($id,Request $request)
   {
    $groupid=GroupUsers::where('group_id',$id)->get();
    if($groupid){
        $alluser=GroupUsers::where('group_id',$id)->delete();
        if($request->user){
            foreach ($request->user as $key => $value) {
               $params['group_id']=$id;
               $params['user_id']=$value;
               GroupUsers::create($params);
               User::where('id',$value)
               ->update([
                   'group_id'=>$id,
                ]);
            }
        }
    }
    else{
        if($request->user){
            foreach ($request->user as $key => $value) {
               $params['group_id']=$id;
               $params['user_id']=$value;
               GroupUsers::create($params);
                User::where('id',$value)
               ->update([
                   'group_id'=>$id,
                ]);
            }
        }
    }
   return redirect()->route('newgroup')->with('success','Member Added Successfully');
   }

    public function UserLogin(Request $request, $id){

        Auth::logout();

        Auth::loginUsingId($id);

        return redirect('/index');
    }


    public function employee_Active($id){
        $data=User::find($id);
        if($data->status=='1'){
            $status='0';
        }else{
            $status='1';
        }
        $data->update([
            'status'=>$status
        ]);
        return back()->with('success', 'Employee status Update successfully.');

    }


    public function getState()
    {
        $data['states'] = State::get(["name","id"]);
        return view('state-city',$data);
    }
    public function getCity(Request $request)
    {
        $data['cities'] = City::where("state_id",$request->state_id)->get(["name","id"]);
        return response()->json($data);
    }

   


}
