<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{Company,City,State,Country,Service_Invoice_History,Source,Lead,Group,GroupUsers,User,ServiceInvoice,Remark,AssignLead};
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Mail\Mailable;
use App\Mail\DemoMail;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ImportLeads;


class CompanyServiceController extends Controller
{
    public function ShowForgetPasswordForm()
    {
        return view('frontend.forgetpassword');
    }

    public function SubmitForgetPasswordForm(Request $request,$value='')
    {
        $request->validate([
              'email' => 'required|email',
          ]);

        $user = User::where('email', $request->email)->first();

                if (!$user) {

                    return back()->with('error', 'The provided email address does not exist. Please enter a valid email address.');
                    
                }
         $token = Str::random(64);

         DB::table('password_resets')->insert([
              'email' => $request->email,
              'token' => $token,
              'created_at' => Carbon::now()
            ]);

         $email=$request->email;
         $details = [
                'title' => 'Mail from Shubham Interprise.com',
                'body' => 'This is for testing email using smtp',
                'token'=> $token
            ];
           
            \Mail::to($email)->send(new \App\Mail\Mail($details));
         

        return back()->with('message', 'We have e-mailed your password reset link!');
    }

    public function ShowResetPasswordForm($token)
    {

         return view('frontend.createnewpassword', ['token' => $token]);
    }


    public function SubmitResetPasswordForm(Request $request)
    {
        $this->validate($request,[
            'email' => 'required|email',
            'password' => 'required',
             'password_confirm' => 'required|same:password'
        ]);

        // Check if the email exists in the 'users' table
        $user = User::where('email', $request->email)->first();

        if (!$user) {
            return back()->withInput()->with('error', 'The provided email address does not exist. Please enter a valid email address.');
        }

        $updatePassword = DB::table('password_resets')
            ->where([
                'email' => $request->email,
                'token' => $request->token
            ])
            ->first();

        if (!$updatePassword) {
            return back()->withInput()->with('error', 'Invalid token!');
        }

       $user = User::where('email', $request->email)
                      ->update(['password' => Hash::make($request->password)]);


        // Delete the password reset record
        DB::table('password_resets')->where(['email' => $request->email])->delete();

        return back()->withInput()->with('message', 'Your password has been changed!');
    }


    public function ShowServiceInvoice(){
        $serviceinv=ServiceInvoice::where('company_id',Auth::user()->company_id)->orderby('id','desc')->get();
        return view('frontend.serviceinvoicepage',compact('serviceinv'));
    }

    public function RemarkSave($id,Request $request){

        $request->validate([
            'followup_type'=>'required',
            'description'=>'required'
        ]);
        $params['lead_id']=$id;
        $params['user_id']=Auth::user()->id;
        $params['description']=$request->description;
        $params['followup_type']=$request->followup_type;
        Remark::create($params);
        return back();
    }

    public function RemarkDelete($id){
        $remark=Remark::find($id);
        $lead=Remark::find($id);
        $remark->delete();
        return redirect()->route('/leadmoreview',['id'=>$lead->lead_id]);
    }

    public function EditRemark($id,Request $request){

         $request->validate([
            'followup_type'=>'required'
        ]);
        Remark::where('id',$id)
        ->update([
            'description'=>$request->description,
            'followup_type'=>$request->followup_type,
        ]);
        $lead=Remark::find($id);
        return redirect()->route('/leadmoreview',['id'=>$lead->lead_id]);
    }

    public function ImportView(){
        return view('frontend.import-page');
    }

    public function DataImport(Request $request){
        Excel::import(new ImportLeads,request()->file('file'));
        return back();

    }
}
