<?php $__env->startSection('main-container'); ?>
<main id="main" class="main">
<?php echo $__env->make('cdn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Products</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="<?php echo e(url('addproduct/create')); ?>">

            <button type="button" class="btn btn-rounded bg-grad-4 ml-4">

                <span class="btn-icon-left" style="color: white">
                + Add Product
                </span>
               

            </button>

        </a>

    </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    <?php echo $__env->make('flash_msg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form method="GET" action="">

                        <div class="row text-right">

                            <div class="col-md-6"></div>

                            <div class="col-md-4">

                                 <input type="text" class="form-control right-search" name="search" value="<?php echo e($request->search); ?>" placeholder="Search by Products Name">

                            </div>

                             <div class="col-md-2">

                                <label class="">&nbsp;</label>

                                <button type="submit" class="btn btn-outline-info bg-grad-4 btn-ft">Search</button>

                            </div>

                        </div>

                    </form>

                    <hr>

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" >
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>PRODUCT NAME</th>

                                    <th>IMAGE</th>

                                    <th>CATEGORY</th>


                                    <th>UNIT</th>

                                    <th>PRICE</th>

                                    <th>STATUS</th>

                                    <th class="text-right">Action</th>

                                </tr>

                            </thead>

                            <tbody>

                                <?php if(!empty($add_products)): ?>

                                <?php $__currentLoopData = $add_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>

                                    <td><?php echo e(++$key); ?></td>

                                    <td><?php echo e($value->name); ?></td>

                                    <td>
                                        <?php if($value->image): ?>
                                        <img src="<?php echo e(url('/uploads/product/'.$value->image)); ?>" height="50" width="50">
                                        <?php endif; ?>
                                    </td>

                                    

                                    <td>
                                        <?php if($value->category!=Null): ?><?php echo e($value->Category->name); ?><?php endif; ?>
                                    </td>

                                    <td><?php echo e($value->unit); ?></td>

                                    <td>₹ <?php echo e($value->product_price); ?> /-</td>

                                    <td>
                                        <?php if($value->status=='1'): ?>

                                            <a href="<?php echo e(url('productactive/'.$value->id)); ?>">

                                                <button class="btn btn-success">Active</button>

                                            </a>
                                            <?php else: ?>
                                            <a href="<?php echo e(url('productactive/'.$value->id)); ?>">

                                                <button class="btn btn-danger">InActive</button>

                                            </a>

                                            <?php endif; ?>
                                    </td>

                                    <td class="text-right">

                                        <a href="<?php echo e(route('products.edit',encrypt($value->id))); ?>"><button type="button" class="btn btn-outline-info btn-ft btn-sm" title="Edit" alt="Edit">Edit</button></a>

                                        <a href="<?php echo e(route('products.delete',encrypt($value->id))); ?>" onclick="return confirm('Are you sure?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Delete" alt="Delete">delete</button></a>

                                    </td>

                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php if($add_products->count() == 0): ?>

                                    <tr class="text-center">

                                        <td colspan="6">No Product to display.</td>

                                    </tr>

                                    <?php endif; ?>

                                <?php endif; ?>

                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Image</th>

                                    <th>Product Name</th>

                                    <th>Part No</th>

                                    <th>Group Name</th>

                                    <th>Unit</th>

                                    <th>Sale Price</th>

                                    <th>Status</th>

                                    <th class="text-right">Action</th>

                                </tr>


                            </tfoot>

                        </table>

                    </div>

                     <div class="text-left float-left mt-1">

                       <p>Displaying <?php echo e($add_products->count()); ?> of <?php echo e($add_products->total()); ?> Add Products.</p>

                    </div>

                    <div class="pagination">
                        <ul class="pagination-list">
                            <?php if($add_products->currentPage() > 1): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($add_products->appends(request()->all())->previousPageUrl()); ?>" class="pagination-link">&lt;</a>
                                </li>
                            <?php endif; ?>

                            <?php if($add_products->currentPage() > 3): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($add_products->appends(request()->all())->url(1)); ?>" class="pagination-link">1</a>
                                </li>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                            <?php endif; ?>

                            <?php $__currentLoopData = range(max(1, $add_products->currentPage() - 2), min($add_products->lastPage(), $add_products->currentPage() + 2)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="pagination-item <?php echo e($page == $add_products->currentPage() ? 'active' : ''); ?>">
                                    <a href="<?php echo e($add_products->appends(request()->all())->url($page)); ?>" class="pagination-link"><?php echo e($page); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php if($add_products->currentPage() < $add_products->lastPage() - 2): ?>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                                <li class="pagination-item">
                                    <a href="<?php echo e($add_products->appends(request()->all())->url($add_products->lastPage())); ?>" class="pagination-link"><?php echo e($add_products->lastPage()); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if($add_products->hasMorePages()): ?>
                                <li class="pagination-item">
                                    <a href="<?php echo e($add_products->appends(request()->all())->nextPageUrl()); ?>" class="pagination-link">&gt;</a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vinecork/public_html/webdev/agentapp/resources/views/product/index.blade.php ENDPATH**/ ?>