<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Login
Route::post('/login', [App\Http\Controllers\API\ApiController::class,'login']);

//users all show
Route::get('/users', [App\Http\Controllers\API\ApiController::class,'userShow']);
//CustomerShow all 
Route::get('/customer', [App\Http\Controllers\API\ApiController::class,'CustomerShow']);

//users id show data
Route::post('/user', [App\Http\Controllers\API\ApiController::class,'userShowid']);

//product all show
Route::post('/products', [App\Http\Controllers\API\ApiController::class,'productShow']);

//product all show
Route::get('/products', [App\Http\Controllers\API\ApiController::class,'productShow']);

//product id show data
Route::post('/product', [App\Http\Controllers\API\ApiController::class,'productShowid']);

//product id show data
Route::post('/productbygroup', [App\Http\Controllers\API\ApiController::class,'product_by_group']);

//Category all show
Route::get('/category', [App\Http\Controllers\API\ApiController::class,'Category_Show']);

//Brands all show
Route::get('/brands', [App\Http\Controllers\API\ApiController::class,'Brand_Show']);



//Complain Store
Route::post('/complain', [App\Http\Controllers\API\ApiController::class,'Complain_Store']);

//Complain Show by User_id
Route::post('/complainbyuser', [App\Http\Controllers\API\ApiController::class,'Complain_Show']);





//order Store
Route::post('/order-store', [App\Http\Controllers\API\ApiController::class,'Order_Save']);

//Order Show by User_id
Route::post('/orderbyuser', [App\Http\Controllers\API\ApiController::class,'Order_Show']);

// Order History order_id wise
Route::get('/order-history/{order_id}',[App\Http\Controllers\API\ApiController::class,'Order_History_Show']);

//Home Banner all show
Route::get('/home_banner', [App\Http\Controllers\API\ApiController::class,'HomeBanner_Show']);

//Report Store
Route::post('/report-store', [App\Http\Controllers\API\ApiController::class,'Report_Save']);

//Report Show by User_id
Route::post('/reportbyuser', [App\Http\Controllers\API\ApiController::class,'Report_Show']);

//Report Show by Day
Route::post('/reportday', [App\Http\Controllers\API\ApiController::class,'Report_Day']);

//Suggestion Store
Route::post('/suggestion', [App\Http\Controllers\API\ApiController::class,'Suggestion_Store']);

//Suggestion Show by User_id
Route::post('/suggestion_by_user', [App\Http\Controllers\API\ApiController::class,'Suggestion_Show']);

//Suggestion delete
Route::post('/suggestion_delete', [App\Http\Controllers\API\ApiController::class,'Suggestion_Delete']);

//Info-Alert all show
Route::get('/info_alerts', [App\Http\Controllers\API\ApiController::class,'InfoAlert_Show']);



// attendance 

Route::get('/getAgentAttendance/{id}',[App\Http\Controllers\API\ApiController::class,'my_attendance_post']);

//Attendence Store

Route::post('/attendanceSave', [App\Http\Controllers\API\ApiController::class,'Attendence_Store']);

//Attendence Updated

Route::post('/attendanceUpdate', [App\Http\Controllers\API\ApiController::class,'Attendence_Update']);

//Attendence Show by User_id
Route::post('/attendencebyuser', [App\Http\Controllers\API\ApiController::class,'Attendence_Show']);

//Attendence Show by Day
Route::post('/attendenceday', [App\Http\Controllers\API\ApiController::class,'Attendence_Day']);



//Shops Store 
Route::post('/ShopsSave',[App\Http\Controllers\API\ApiController::class,'ShopSave']);







