@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Products</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{url('addproduct/create')}}">

            <button type="button" class="btn btn-rounded bg-grad-4 ml-4">

                <span class="btn-icon-left" style="color: white">
                + Add Product
                </span>
               

            </button>

        </a>

    </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form method="GET" action="">

                        <div class="row text-right">

                            <div class="col-md-6"></div>

                            <div class="col-md-4">

                                 <input type="text" class="form-control right-search" name="search" value="{{$request->search}}" placeholder="Search by Products Name">

                            </div>

                             <div class="col-md-2">

                                <label class="">&nbsp;</label>

                                <button type="submit" class="btn btn-outline-info bg-grad-4 btn-ft">Search</button>

                            </div>

                        </div>

                    </form>

                    <hr>

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" >
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>PRODUCT NAME</th>

                                    <th>IMAGE</th>

                                    <th>CATEGORY</th>


                                    <th>UNIT</th>

                                    <th>PRICE</th>

                                    <th>STATUS</th>

                                    <th class="text-right">Action</th>

                                </tr>

                            </thead>

                            <tbody>

                                @if(!empty($add_products))

                                @foreach($add_products as $key=>$value)

                                <tr>

                                    <td>{{ ++$key }}</td>

                                    <td>{{ $value->name }}</td>

                                    <td>
                                        @if($value->image)
                                        <img src="{{ url('/uploads/product/'.$value->image) }}" height="50" width="50">
                                        @endif
                                    </td>

                                    

                                    <td>
                                        @if($value->category!=Null){{ $value->Category->name }}@endif
                                    </td>

                                    <td>{{ $value->unit }}</td>

                                    <td>₹ {{ $value->product_price }} /-</td>

                                    <td>
                                        @if($value->status=='1')

                                            <a href="{{url('productactive/'.$value->id)}}">

                                                <button class="btn btn-success">Active</button>

                                            </a>
                                            @else
                                            <a href="{{url('productactive/'.$value->id)}}">

                                                <button class="btn btn-danger">InActive</button>

                                            </a>

                                            @endif
                                    </td>

                                    <td class="text-right">

                                        <a href="{{ route('products.edit',encrypt($value->id)) }}"><button type="button" class="btn btn-outline-info btn-ft btn-sm" title="Edit" alt="Edit">Edit</button></a>

                                        <a href="{{ route('products.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Delete" alt="Delete">delete</button></a>

                                    </td>

                                    </tr>

                                @endforeach

                                    @if ($add_products->count() == 0)

                                    <tr class="text-center">

                                        <td colspan="6">No Product to display.</td>

                                    </tr>

                                    @endif

                                @endif

                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Image</th>

                                    <th>Product Name</th>

                                    <th>Part No</th>

                                    <th>Group Name</th>

                                    <th>Unit</th>

                                    <th>Sale Price</th>

                                    <th>Status</th>

                                    <th class="text-right">Action</th>

                                </tr>


                            </tfoot>

                        </table>

                    </div>

                     <div class="text-left float-left mt-1">

                       <p>Displaying {{$add_products->count()}} of {{ $add_products->total() }} Add Products.</p>

                    </div>

                    <div class="pagination">
                        <ul class="pagination-list">
                            @if ($add_products->currentPage() > 1)
                                <li class="pagination-item">
                                    <a href="{{ $add_products->appends(request()->all())->previousPageUrl() }}" class="pagination-link">&lt;</a>
                                </li>
                            @endif

                            @if ($add_products->currentPage() > 3)
                                <li class="pagination-item">
                                    <a href="{{ $add_products->appends(request()->all())->url(1) }}" class="pagination-link">1</a>
                                </li>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                            @endif

                            @foreach(range(max(1, $add_products->currentPage() - 2), min($add_products->lastPage(), $add_products->currentPage() + 2)) as $page)
                                <li class="pagination-item {{ $page == $add_products->currentPage() ? 'active' : '' }}">
                                    <a href="{{ $add_products->appends(request()->all())->url($page) }}" class="pagination-link">{{ $page }}</a>
                                </li>
                            @endforeach

                            @if ($add_products->currentPage() < $add_products->lastPage() - 2)
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                                <li class="pagination-item">
                                    <a href="{{ $add_products->appends(request()->all())->url($add_products->lastPage()) }}" class="pagination-link">{{ $add_products->lastPage() }}</a>
                                </li>
                            @endif

                            @if ($add_products->hasMorePages())
                                <li class="pagination-item">
                                    <a href="{{ $add_products->appends(request()->all())->nextPageUrl() }}" class="pagination-link">&gt;</a>
                                </li>
                            @endif
                        </ul>
                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
 @endsection
