@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Edit Product</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

         <a href="{{route('products')}}" class="btn btn-rounded bg-grad-4 ml-4">

            <span class="btn-icon-left" style="color: white">
                Back
            </span>

        </a>

    </div>

</div>



<div class="content-wrapper" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                        <form action="{{route('products.update',$product->id)}}" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}

                        <!-- Modal body -->
                        <div class="row">
                            <div class="form-group col-lg-6">
                                <label> Product Name <span class="text-danger">*</span></label>
                                   <input type="text" class="form-control" name="name" value="{{ $product->name }}" placeholder="Name">
                                <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
                            </div>

                            
                            <div class="form-group col-lg-6">
                                <label>Category <span class="text-danger"></span></label>
                                 <select class=" form-control custom-select" name="category" data-toggle="dropdown">
                                    <option value="">Select Category</option>
                                     @foreach($category as $cat)
                                     @if($product->category==$cat->id)
                                     <option value="{{ $cat->id }}" selected>{{ $cat->name }}</option>
                                     @else
                                     <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                     @endif
                                     @endforeach
                                </select>
                                <span class="text-danger">@error('category'){{ $message }}@enderror</span>
                            </div>

                            <div class="form-group col-lg-6">

                                <label>Unit <span class="text-danger"></span></label>

                                 <select class=" form-control custom-select" name="unit" data-toggle="dropdown" >
                                    @if($product->unit)
                                    <option value="{{$product->unit}}">{{$product->unit}}</option>
                                    @else
                                    <option value="">Select Unit</option>
                                    <option value="KG">KG</option>
                                    <option value="GM">GM</option>
                                    <option value="LTR">LTR</option>
                                    <option value="ML">ML</option>
                                    <option value="PCS">PCS</option>
                                    @endif
                                </select>

                                <span class="text-danger"> @error('unit'){{ $message }}@enderror </span>
 
                            </div>

                            <div class="form-group col-lg-6">

                                <label>MRP <span class="text-danger">*</span></label>

                                <input type="text" class="form-control" name="product_price" value="{{ $product->product_price }}" placeholder="Enter MRP" required>

                                @error('product_price'){{ $message }}@enderror 

                            </div>

                            <div class="form-group col-lg-6">

                                <label>GST(%) <span class="text-danger"></span></label>

                                <input type="text" class="form-control" name="GST" value="{{ $product->GST }}" placeholder="Gst Value in %">

                                <span class="text-danger"> @error('GST'){{ $message }}@enderror </span>

                            </div>


                            <div class="form-group col-lg-6">

                                <label>Stock quatity<span class="text-danger"></span></label>

                                <input type="text" class="form-control" name="stock_qty" value="{{ $product->stock_qty }}" placeholder="Enter Stock Quatity">

                                <span class="text-danger"> @error('stock_qty'){{ $message }}@enderror </span>

                            </div>

                            <div class="form-group col-lg-6">

                                <label>Agent Commission(%)<span class="text-danger"></span></label>

                                <input type="text" class="form-control" name="agent_commission" value="{{ $product->agent_commission }}" placeholder="Agent Commission">

                                <span class="text-danger"> @error('agent_commission'){{ $message }}@enderror </span>

                            </div>

                            <div class="form-group col-lg-6">

                                <label>Image <span class="text-danger">*</span></label>

                                <input type="file" class="form-control" name="image" value="{{$product->image}}" id="avatar" accept="image/png, image/jpeg">

                                <img src="{{url('/uploads/product/'.$product->image)}}" alt="Avatar" class="mt-2" style="height:30px; width:35px;">

                                <span class="text-danger"> @error('image'){{ $message }}@enderror </span>

                            </div>

                            <div class="form-group col-lg-6">

                                <label>Offer Title <span class="text-danger"></span></label>

                                <input type="text" class="form-control" name="offer_title" placeholder="Enter Offer Title" value="{{$product->offer_title}}">

                                <span class="text-danger"> @error('offer_title'){{ $message }}@enderror </span>

                            </div>

                            <div class="form-group col-lg-6">

                                <label>Offer Image <span class="text-danger"></span></label>

                                <input type="file" class="form-control" name="offer_image" value="{{$product->offer_image}}" id="image">
                                <img src="{{url('/uploads/product/'.$product->offer_image)}}" class="mt-2" alt="avatar1" style="height:30px; width:35px;">

                                <span class="text-danger"> @error('offer_image'){{ $message }}@enderror </span>

                            </div>


                            <div class="form-group col-lg-6">
                                <label>Description <span class="text-danger"></span></label>
                                <div class="input-group mb-2">
                                    <textarea type="number" class="form-control" name="description"  placeholder="Description" >{{ $product->description }}</textarea>
                                </div>
                                <span class="text-danger"> @error('description'){{ $message }}@enderror </span>
                            </div>

                            <div class="form-group col-lg-12">

                                        <label>Product Features <span class="text-danger"></span></label>

                                        <textarea class="form-control ckeditor" name="product_features" placeholder="Enter Message">{{$product->product_features }}</textarea>

                                        <span class="text-danger"> @error('product_features'){{ $message }}@enderror </span>

                            </div>

                        </div>

                        <div class="text-center">

                            <button type="submit" class="btn btn-success">Submit</button>

                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

      </div>
</main><!-- End #main -->
 @endsection

 <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
 <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>

