@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Orders</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{route('/')}}" class="btn btn-rounded bg-grad-4 ml-4">

           <span class="btn-icon-left" style="color: white">
                Back
            </span>

       </a>

   </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                     <form action="{{ route('user_by_search_order.search') }}" method="get">
                        <div class="row">
                            <div class="form-group col-md-4">
                                <select class="form-control dropdown-toggle" name="user_id" type="button" data-toggle="dropdown">
                                    <option value="">Select User</option>
                                    @foreach($users as $user)
                                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2 form-group">
                                <input type="submit" class="btn btn-primary" value="Filter">
                            </div>

                            <div class="form-group col-md-4">
                                <select class="form-control dropdown-toggle" name="employee_id" type="button" data-toggle="dropdown">
                                    <option value="">Select Employee</option>
                                    @foreach($employee as $employee)
                                        <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2 form-group">
                                <input type="submit" class="btn btn-primary" value="Filter">
                            </div>
                        </div>
                    </form>

                    <hr>

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" >
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>CREATED BY</th>

                                    <th>CUSTOMER NAME</th>

                                    <th>AMOUNT</th>

                                    <th>DATE</th>

                                    <th class="text-right">Action</th>

                                </tr>

                            </thead>


                            <tbody>

                                @if(!empty($orders))

                                @foreach($orders as $key=>$value)

                                <tr>

                                    <td>{{ ++$key }}</td>

                                    <td>{{ $value->User->name ?? 'N/A'}}</td>

                                    <td>{{ $value->Customer->name ?? 'N/A'}}</td>

                                    <td>₹ {{ $value->amount }} /-</td>

                                    <td>{{ $value->created_at->format('d-m-Y') }}</td>


                                    <td class="text-right">
                                        
                                        <a href="{{ route('order.view',encrypt($value->id)) }}"><button type="button" class="btn btn-outline-info btn-ft btn-sm" title="Edit" alt="Edit">View</button></a>

                                         <a href="{{ route('order.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Delete" alt="Delete">delete</button></a>

                                    </td>

                                    </tr>

                                @endforeach

                                    @if ($orders->count() == 0)

                                    <tr class="text-center">

                                        <td colspan="6">No Orders to display.</td>

                                    </tr>

                                    @endif

                                @endif

                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>Created By</th>

                                    <th>Customer Name</th>

                                    <th>Amount</th>

                                    <th>Date</th>

                                    <th class="text-right">Action</th>

                                </tr>


                            </tfoot>

                        </table>

                    </div>

                     <div class="text-left float-left mt-1">

                           <p>Displaying {{$orders->count()}} of {{ $orders->total() }} Add Order.</p>

                    </div>


                    <div class="pagination">
                        <ul class="pagination-list">
                            @if ($orders->currentPage() > 1)
                                <li class="pagination-item">
                                    <a href="{{ $orders->appends(request()->all())->previousPageUrl() }}" class="pagination-link">&lt;</a>
                                </li>
                            @endif

                            @if ($orders->currentPage() > 3)
                                <li class="pagination-item">
                                    <a href="{{ $orders->appends(request()->all())->url(1) }}" class="pagination-link">1</a>
                                </li>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                            @endif

                            @foreach(range(max(1, $orders->currentPage() - 2), min($orders->lastPage(), $orders->currentPage() + 2)) as $page)
                                <li class="pagination-item {{ $page == $orders->currentPage() ? 'active' : '' }}">
                                    <a href="{{ $orders->appends(request()->all())->url($page) }}" class="pagination-link">{{ $page }}</a>
                                </li>
                            @endforeach

                            @if ($orders->currentPage() < $orders->lastPage() - 2)
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                                <li class="pagination-item">
                                    <a href="{{ $orders->appends(request()->all())->url($orders->lastPage()) }}" class="pagination-link">{{ $orders->lastPage() }}</a>
                                </li>
                            @endif

                            @if ($orders->hasMorePages())
                                <li class="pagination-item">
                                    <a href="{{ $orders->appends(request()->all())->nextPageUrl() }}" class="pagination-link">&gt;</a>
                                </li>
                            @endif
                        </ul>
                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
 @endsection
