@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')   
<div class="content-wrapper">
  <div class="row">
    <div class="card">
      <div class="card-body">

               <h4 class="card-title">LEAD INFORMATION</h4>
                  
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                    <label class="col-sm-4 col-form-label">Name:</label>
                      <div class="col-sm-8" >
                        <p style="padding-top: 6px;">{{$leads->name}}</p>                
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Lead Source:</label>
                      <div class="col-sm-7">
                        @if($leads->l_source==null)
                        <p style="padding-top: 6px;"></p>
                        @else
                        <p style="padding-top: 6px;">{{$leads->source->name}}</p>
                        @endif
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row">
                   <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Investment:</label>
                      <div class="col-sm-8">
                         <p style="padding-top: 6px;">{{$leads->invest}}</p>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Trading Experience:</label>
                      <div class="col-sm-7">
                        <p style="padding-top: 6px;">{{$leads->expense}}</p>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Trading Segment:</label>
                      <div class="col-sm-8">
                        <p style="padding-top: 6px;">{{$leads->trade}}</p>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Created By:</label>
                      <div class="col-sm-7">
                         <p style="padding-top: 6px;">{{$leads->createdby->name}}</p>
                      </div>
                    </div>
                  </div>
                </div>
                 <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Assigned:</label>
                      <div class="col-sm-8">
                        @if($leads->assigned==0)
                        <p style="padding-top: 6px;"> </p>
                        @else
                         <p style="padding-top: 6px;">{{$leads->assign->name}}</p>
                        @endif
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Status:</label>
                      <div class="col-sm-7">
                        @if($leads->status==1)
                         <p style="padding-top: 6px;"><span style="background-color: #fd7e14;"> &ensp; Contact &ensp; </span></p>
                        @endif
                        @if($leads->status==2)
                        <p style="padding-top: 6px;"><span style="background-color:#fd7e14;"> &ensp; Paid &ensp;  </span></p>
                        @endif
                        @if($leads->status==0)
                        <p style="padding-top: 6px;"><span style="background-color:#fd7e14;"> &ensp;Default &ensp; </span></p>
                        @endif
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Follow Up Status:</label>
                      <div class="col-sm-8">
                        <p style="padding-top: 6px;"><span>{{$leads->follow_up}}</span></p>
                      </div>
                    </div>
                  </div>                
                </div>


                <h4 class="card-title">CONTACT INFO</h4>
               

                <div class="row">
                   <div class="col-md-6">
                        <div class="form-group row">
                          <label class="col-sm-4 col-form-label">Country:</label>
                          <div class="col-sm-8">
                              @if($leads->country=='Default')
                              <p style="padding-top: 6px;">{{$leads->country}}</p>
                              @else
                              <p style="padding-top: 6px;">{{$leads->country_info->name}}</p>
                              @endif
                          </div>
                        </div>
                    </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Contact Number:</label>
                      <div class="col-sm-7">
                         <p style="padding-top: 6px;">{{$leads->phone}}</p> 
                      </div>
                    </div>
                  </div>            
                </div>

                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-4 col-form-label">Email:</label>
                      <div class="col-sm-8">
                       <p style="padding-top: 6px;">{{$leads->email}}</p>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label class="col-sm-5 col-form-label">Additional Number:</label>
                      <div class="col-sm-7">
                        <p style="padding-top: 6px;">{{$leads->mobile}}</p>
                      </div>
                    </div>
                  </div>      
                </div>
     
                <h4 class="card-title">ADDITIONAL INFORMATION</h4>
              
                <div class="row">
                  <div class="col-md-8">
                    <div class="form-group row">
                      <label class="col-sm-3 col-form-label">Description:</label>
                      <div class="col-sm-9">
                         <p style="padding-top: 6px;">{{$leads->notes}}</p>
                      </div>
                    </div>
                  </div>
                    <br>
                    <br>
                </div>

                <h4 class="card-title p-2" style="background-color:#afd6e8;">Remarks</h4>
                @if(count($leads->remark)==0)
                <h6> Remark Not Found!</h6>
                @else
                @foreach($leads->remark as $remark)
                 <div class="row p-2">
                   <div class="row">
                    <div class="col-md-5">
                     <div class="form-group">
                      <span><strong>Date:</strong>&ensp;{{$remark->created_at->format('d/m/Y')}}</span>
                     </div>
                    </div>
                     <div class="col-md-7">
                            <span><strong>Follow Up:&nbsp;</strong></span>
                             @foreach($remark->followup_type as $arr)
                             <span style="background-color: #FBBE3F;">{{$arr}}&nbsp;</span>
                             @endforeach       
                    </div>
                   </div>
                   <div class="row">
                    <div class="col-md-10">
                            <span><strong>Description:&nbsp;</strong>&nbsp;{{$remark->description}}</span>  
                    </div>
                    
                    <div class="col-md-2 d-inline">
                           <a role="button" data-toggle="modal" data-target="#remarkedit-{{$remark}}"><i class="bi bi-pencil-fill"></i></a>&ensp;

                            <!--Remark Edit Modal -->
                            <div class="modal fade" id="remarkedit-{{$remark}}" tabindex="-1" role="dialog" aria-labelledby="editModalLabe2" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="editModalLabe2" >Edit Remark</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>  
                              <form action="{{url('/editremark/'.$remark->id)}}" method="post">
                                {{ csrf_field() }}

                              <div class="modal-body" style="background-color:#F3F2EE ;">
                                <div class="row mb-3">
                                  <strong for="inputText" class=" col-form-label">Follow Up<span style="color:red;">*</span>:</strong>
                                  <div class="p-2">
                                   @foreach(array('Email','Call','Message') as $arr)
                                   &ensp; &ensp;&ensp;
                                   @if(in_array($arr,$remark->followup_type))
                                   <input class="form-check-input" type="checkbox" name="followup_type[]" id="inlineCheckbox1" value="{{$arr}}" checked> &nbsp;{{$arr}} &ensp; &ensp; &ensp;&ensp;
                                   @else
                                   <input class="form-check-input" type="checkbox" name="followup_type[]" id="inlineCheckbox1" value="{{$arr}}" > &nbsp;{{$arr}} &ensp; &ensp; &ensp;&ensp;&ensp;&ensp;
                                   @endif
                                   @endforeach
                                  </div>          
                                </div>
                                <div class="row mb-3">
                                  <strong for="inputText" class=" col-form-label">Remark<span style="color:red;">*</span>:</strong>
                                  <div class="p-2">
                                   <textarea type="text" name="description" class="form-control" placeholder="Type Here.." value="{{$remark->description}}" required>{{$remark->description}}</textarea>
                                  </div>  
                                </div>  
                               </div>
                               <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Submit</button>
                               </div>
                          </form>
                          </div>
                          </div>
                          </div> 

                           <!-- <a href="{{url('remarkdelete',$remark->id)}}"><i class="bi bi-trash"></i></a> -->
                      </div>
                    </div>
                    <br>
                    <br>
                 </div>
                 @endforeach
                @endif
              <div class="col-md-12">
                  <div class="form-group row" style="float: right;">
                    <a href="{{ url()->previous() }}" class="auth-link text-black">Back..
                    </a>
                  </div>
              </div>
            </div>
          </div>
        </div>
      </div>
</main><!-- End #main -->
@endsection