@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Edit Agent</h3>

        </div>

    </div>

     <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

         <a href="{{route('showallAgents')}}" class="btn btn-rounded bg-grad-4 ml-4">

            <span class="btn-icon-left" style="color: white">Back</span>

        </a>

    </div>

</div>



<div class="content-wrapper" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="{{route('agent.update',$users->id)}}" method="POST" class="form-sample" enctype="multipart/form-data">
                            {{ csrf_field() }}

                        <!-- Modal body -->
                        <div class="row">

                                <div class="form-group col-lg-6">
                                  <label>Name<span class="text-danger">*</span></label>
                                  <input type="text" class="form-control" name="name" value="{{$users->name}}" placeholder="Name">
                                  <span class="text-danger"> @error('name'){{ $message }}@enderror </span>
                                </div>

                                 <div class="form-group col-lg-6">
                                    <label>Mobile<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="mobile" value="{{$users->mobile}}" placeholder="Enter Mobile No">
                                    <span class="text-danger"> @error('mobile'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Email<span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" name="email" value="{{$users->email}}" placeholder="Enter Email Id">
                                    <span class="text-danger"> @error('email'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Password<span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="password" value="{{$users->password}}" placeholder="Enter password Id">
                                    <span class="text-danger"> @error('password'){{ $message }}@enderror </span>
                                </div>

                                


                                <div class="form-group col-lg-6">
                                    <label>DOB<span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" name="dob" value="{{$users->DOB}}" placeholder="Enter date of birth">
                                    <span class="text-danger"> @error('dob'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Code<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="code" value="{{$users->code}}" placeholder="">
                                    <span class="text-danger"> @error('code'){{ $message }}@enderror </span>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label for="state">State<span class="text-danger">*</span></label>
                                    <select class="form-control" id="state-dropdown" name="state">
                                        <option value="">Select State</option>
                                        @foreach ($states as $state)
                                        <option value="{{$state->id}}" {{$state->id==$users->state?'selected':''}}>{{$state->state_name}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label for="district">District<span class="text-danger">*</span></label>
                                    <select class="form-control" id="district-dropdown" name="district">
                                        <option value="{{$users->district}}">{{$users->District->dist_name}}</option>

                                    </select>
                                </div>


                                <div class="form-group col-lg-6">
                                    <label>Village/City<span class="text-danger">*</span></label>
                                     <input type="text" class="form-control" name="city" value="{{$users->city}}" placeholder="Enter City/Village Name">
                                    <span class="text-danger"> @error('city'){{ $message }}@enderror </span>
                                    
                                </div>

                                <div class="form-group col-lg-6">
                                    <label>Address<span class="text-danger"></span></label>
                                     <textarea type="text" class="form-control" name="address" value="{{$users->address}}" placeholder="Enter Address">{{$users->address}}</textarea>
                                    <span class="text-danger"> @error('address'){{ $message }}@enderror </span>
                                    
                                </div>

                                <div class="text-center">
                                    <button type="submit"  class="btn btn-primary" style="margin-right:7px;">Submit</button>
                                </div>
                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>

<script type="text/javascript">
    $("document").ready(function(){
     setTimeout(function()
     {
         $("div.alert").remove();

     }, 3000);

    });

</script>

<script>
    $(document).ready(function() {
        $('#state-dropdown').on('change', function() {
            var state_id = this.value;
            $("#district-dropdown").html('');
            $.ajax({
                url:"{{url('get-district-by-state')}}",
                type: "POST",
                data: {
                    state_id: state_id,
                    _token: '{{csrf_token()}}'
                },
                dataType : 'json',
                success: function(result) {
                    $.each(result.district, function(key, value) {
                        $("#district-dropdown").append('<option value="'+value.id+'">'+value.dist_name+'</option>');
                    });
                }
            });
        });
    });
</script>
 @endsection

 <script>
    $(document).ready(function() {
        $('#state-dropdown').on('change', function() {
            var state_id = this.value;
            $("#city-dropdown").html('');
            $.ajax({
                url:"{{url('get-cities-by-state')}}",
                type: "POST",
                data: {
                    state_id: state_id,
                    _token: '{{csrf_token()}}'
                },
                dataType : 'json',
                success: function(result) {
                    $.each(result.cities, function(key, value) {
                        $("#city-dropdown").append('<option value="'+value.id+'">'+value.name+'</option>');
                    });
                }
            });
        });
    });
</script>




