@extends('frontend.layouts.main')
@section('main-container')
<main id="main" class="main">
@include('cdn')

<div class="row page-titles mx-0">

    <div class="col-sm-6 p-md-0">

        <div class="breadcrumb-range-picker">

             <h3>Attendence</h3>

        </div>

    </div>

    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

        <a href="{{route('/')}}" class="btn btn-rounded bg-grad-4 ml-4">

           <span class="btn-icon-left" style="color: white">
                Back
            </span>

       </a>

   </div>

</div>

<div class="container-fluid" style="margin-top: 15px">

    @include('flash_msg')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <form action="{{ route('employee_by_search_attendence.search') }}" method="get">
                        <div class="row">
                            <div class="form-group col-md-4">
                                <select class="form-control dropdown-toggle" name="employee_id" type="button" data-toggle="dropdown">
                                    <option value="">Select Employee</option>
                                    @foreach($users as $user)
                                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2 form-group">
                                <input type="submit" class="btn btn-primary" value="Filter">
                            </div>
                        </div>
                    </form>

                    <hr>

                    <div class="table-responsive">

                        <table class="table table-border table-hover table-sm" >
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>USER NAME</th>

                                    <th>LONGITUDE</th>

                                     <th>LATITUDE</th>

                                     <th>LOCATION</th>

                                     <th>DATE</th>

                                     <th>TIME_IN</th>

                                     <th>TIME_OUT</th>

                                    <th class="text-right">Action</th>

                                </tr>

                            </thead>


                            <tbody>

                                @if(!empty($attendences))

                                @foreach($attendences as $key=>$value)

                                <tr>

                                    <td>{{ ++$key }}</td>

                                    <td>{{ $value->User->name ?? 'N/A' }}</td>

                                    <td>{{ $value->in_longitude}}<br>{{ $value->out_longitude }}</td>

                                    <td>{{ $value->in_latitude}}<br>{{ $value->out_latitude }}</td>

                                    <td>{{ $value->in_location }}<br>{{ $value->out_location }}</td>

                                    <td>{{ \Carbon\Carbon::parse($value->date)->format('d-m-Y') }}</td>

                                    <td>{{ $value->time_in}}</td>

                                    <td>{{ $value->time_out}}</td>

                                     <td class="text-right">

                                         <a href="{{ route('attendence.delete',encrypt($value->id)) }}" onclick="return confirm('Are you sure?')"><button type="button" class="btn btn-outline-primary btn-ft btn-sm" title="Delete" alt="Delete">delete</button></a>

                                    </td>

                                    </tr>

                                @endforeach

                                    @if ($attendences->count() == 0)

                                    <tr class="text-center">

                                        <td colspan="6">No Attendances to display.</td>

                                    </tr>

                                    @endif

                                @endif

                            </tbody>

                            <tfoot>

                                <tr>
                                    <th>#</th>

                                    <th>User Name</th>

                                    <th>Longtude</th>

                                     <th>Latitude</th>

                                     <th>Location</th>

                                     <th>Date</th>

                                     <th>Time_in</th>

                                     <th>Time_out</th>

                                    <th class="text-right">Action</th>

                                </tr>


                            </tfoot>

                        </table>

                    </div>

                     <div class="text-left float-left mt-1">

                           <p>Displaying {{$attendences->count()}} of {{ $attendences->total() }} Add Attendence.</p>

                    </div>

                    <div class="text-right float-right">

                         {{-- {{ $memberships->appends(request()->all())->links() }} --}}

                    </div>


                    <div class="pagination">
                        <ul class="pagination-list">
                            @if ($attendences->currentPage() > 1)
                                <li class="pagination-item">
                                    <a href="{{ $attendences->appends(request()->all())->previousPageUrl() }}" class="pagination-link">&lt;</a>
                                </li>
                            @endif

                            @if ($attendences->currentPage() > 3)
                                <li class="pagination-item">
                                    <a href="{{ $attendences->appends(request()->all())->url(1) }}" class="pagination-link">1</a>
                                </li>
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                            @endif

                            @foreach(range(max(1, $attendences->currentPage() - 2), min($attendences->lastPage(), $attendences->currentPage() + 2)) as $page)
                                <li class="pagination-item {{ $page == $attendences->currentPage() ? 'active' : '' }}">
                                    <a href="{{ $attendences->appends(request()->all())->url($page) }}" class="pagination-link">{{ $page }}</a>
                                </li>
                            @endforeach

                            @if ($attendences->currentPage() < $attendences->lastPage() - 2)
                                <li class="pagination-item disabled">
                                    <span class="pagination-link">...</span>
                                </li>
                                <li class="pagination-item">
                                    <a href="{{ $attendences->appends(request()->all())->url($attendences->lastPage()) }}" class="pagination-link">{{ $attendences->lastPage() }}</a>
                                </li>
                            @endif

                            @if ($attendences->hasMorePages())
                                <li class="pagination-item">
                                    <a href="{{ $attendences->appends(request()->all())->nextPageUrl() }}" class="pagination-link">&gt;</a>
                                </li>
                            @endif
                        </ul>
                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
</main><!-- End #main -->
 @endsection
