<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;
    protected $fillable = ['user_id','GST','status','logo','country','state','city','name','address'];

    public function country_info(){
        return $this->hasOne(Country::class,"id","country");
    }

     public function state_info(){
        return $this->hasOne(State::class,"id","state");
    }

     public function city_info(){
        return $this-> hasOne(City::class,"id","city");
    }
}
