<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Report;
use App\Models\Role;
use Carbon\Carbon;

class ReportController extends Controller
{
    public function index(Request $request) {

        $users = User::where('role', 'Employee')->get();
        if ($request->search) {
            $searchDate = Carbon::createFromFormat('d-m-Y', $request->search)->format('Y-m-d');

            $reports = Report::orderBy('id', 'DESC')
                ->whereDate('date', $searchDate)
                ->paginate(10);
        } else {
            $reports = Report::orderBy('id', 'DESC')->paginate(10);
        }

        return view('report.index', compact('reports', 'request','users'));
    }


    public function search(Request $request)
    {
        // Fetch only users with the role 'Employee'
        $users = User::where('role', 'Employee')->get();

        $reports = Report::orderBy('id', 'desc')
            ->with('user')
            ->when($request->employee_id, function ($query) use ($request) {
                $query->where('user_id', $request->employee_id);
            })
            ->paginate(10);

        return view('report.index', compact('reports', 'users', 'request'));
    }

    public function delete($id)
    {
        $id=decrypt($id);

        $reports = Report::find($id);

        $reports->delete();

        return redirect('report')->with('error','Report deleted successfully.');
    }
}
